% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetricPolynomials.R
\name{PSPexpression}
\alias{PSPexpression}
\title{Symmetric polynomial in terms of the power sum polynomials}
\usage{
PSPexpression(qspray)
}
\arguments{
\item{qspray}{a symmetric \code{qspray} polynomial; symmetry is not checked}
}
\value{
A \code{qspray} polynomial, say \eqn{P}, such that 
  \eqn{P(p_1, ..., p_n)} equals the input symmetric polynomial, 
  where \eqn{p_i} is the i-th power sum polynomial (\code{PSFpoly(n, i)}).
}
\description{
Expression of a symmetric \code{qspray} polynomial as a 
  polynomial in the power sum polynomials.
}
\examples{
# take a symmetric polynomial
( qspray <- ESFpoly(4, c(2, 1)) + ESFpoly(4, c(2, 2)) )
# compute the power sum expression
( pspExpr <- PSPexpression(qspray) )
# take the involved power sum polynomials
psPolys <- lapply(1:numberOfVariables(pspExpr), function(i) PSFpoly(4, i))
# then this should be TRUE:
qspray == changeVariables(pspExpr, psPolys)
}
\seealso{
\code{\link{PSPcombination}}
}
