% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getHolidays}
\alias{getHolidays}
\alias{getBusinessDays}
\title{Compute holidays or business days}
\usage{
getHolidays(from, to, includeWeekends = FALSE, xp = NULL)

getBusinessDays(from, to, xp = NULL)
}
\arguments{
\item{from}{A Date object with the start date}

\item{to}{A Date object with the end date}

\item{includeWeekends}{A boolean indicating if weekends should be included, default
is \sQuote{FALSE}}

\item{xp}{An optional calendar object, if missing the default instance is used}
}
\value{
A Date vector with holidays or business days between the given dates
}
\description{
Compute the number of holidays (or business days) between two dates
}
\details{
This function takes a start and end date and returns a vector of holidays
(or business days) between them according to the active calendar.
}
\examples{
getHolidays(Sys.Date(), Sys.Date() + 30)
}
