% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcreg.R
\name{qcreg}
\alias{qcreg}
\title{Quasi-Cauchy quantile regression}
\usage{
qcreg(formula, data, tau=0.5, npi=100, criterion="bic", tau_i=0.05, tau_f=0.95)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms, separated by + operators, on the right.}

\item{data}{a \code{data.frame()} composed of the variables that will be used in the model.}

\item{tau}{the quantile to be estimated, this is a number strictly between 0 and 1. The default value is 0.5.}

\item{npi}{(optional) the number of Pi's that will be considered for choosing the Pi that best fits the model. The default value is 100.}

\item{criterion}{(optional) criterion to decide the Pi that fits the model. Choose "aic" for AIC, "bic" for BIC and "R2" for pseudo-R2. Or, indicate a numerical value between 0<Pi<pi to use a particular Pi. The default is the automatic choice of Pi following the BIC criterion.}

\item{tau_i}{(optional) if you want to estimate several quantiles simultaneously, enter the lower limit of the range of coatis you want to estimate here. The default value is 0.05.}

\item{tau_f}{(optional) if you want to estimate several quantiles simultaneously, enter the upper limit of the range of coatis you want to estimate here. The default value is 0.95.}
}
\value{
\code{qcreg()} returns an object of class \code{rq()}, hence all outputs of an \code{rq()} object are accessible.

\code{index} returns the Pi value used in estimating the model and 4 goodness-of-fit criteria, namely: AIC, BIC, pseudo-R2, adjusted pseudo-R2.

\code{effects} returns the marginal effect on the average.

\code{quantregplot} returns argument for graphical visualization of estimates (and confidence intervals) considering a range of values for tau instead of a single value.

\code{pis} returns the values of Pi considered in the procedure for choosing the ideal Pi, as well as the corresponding goodness-of-fit criterion values. Available only when Pi is chosen via goodness-of-fit criteria.
}
\description{
Returns an object of class \code{rq()} that represents a Quasi-Cauchy quantile regression fit. Quasi-Cauchy quantile regression is useful when you want to perform quantile regression analysis on data limited to the unit range.
}
\details{
The Quasi-Cauchy quantile regression model is based on the traditional quantile model, proposed by Koenker (2005) (\url{doi:10.1017/CBO9780511754098}), to which the Quasi-Cauchy link function is added, allowing the estimation of quantile regression when modeling a variable of nature limited to the ranges [0,1], (0,1], [0,1) or (0,1). For more details on Quasi-Cauchy quantile regression, see de Oliveira, Ospina, Leiva, Figueroa-Zuniga and Castro (2023) (\url{doi:10.3390/fractalfract7090667}).
}
\examples{

data("Democratization", package = "qcauchyreg")

fit <- qcreg(democratization ~ schooling + press_freedom, data = Democratization, criterion=1)
summary(fit)
fit$effects
fit$index






data("Poverty", package = "qcauchyreg")

fit2 <- qcreg(poverty ~ population + illiteracy + pc_income, 
data = Poverty, npi=50, criterion="bic")
summary(fit2)
fit2$effects
fit2$index

plot(fit2$pis, type="l")

plot(fit2$quantregplot) 


}
\references{
[1] Koenker, R. W. (2005). Quantile Regression, Cambridge U. Press. \url{doi:10.1017/CBO9780511754098}

[2] de Oliveira, J.S.C.; Ospina, R.; Leiva, V.; Figueroa-Zuniga, J.; Castro, C. (2023). Quasi-Cauchy Regression Modeling for Fractiles Based on Data Supported in the Unit Interval. Fractal Fract. 7, 667. \url{doi:10.3390/fractalfract7090667}
}
\author{
Jose Sergio Case de Oliveira
}
