% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peta2_to_cohensf.r
\name{peta2_to_cohensf}
\alias{peta2_to_cohensf}
\title{Convert Partial Eta Squared to Cohen's f}
\usage{
peta2_to_cohensf(peta2)
}
\arguments{
\item{peta2}{A numeric vector of partial eta squared values.
Each value must be within the range of 0 to 1.}
}
\value{
A numeric vector of Cohen's f values.
}
\description{
Converts partial eta squared (\eqn{\eta_p^2}) to
Cohen's f using the standard definition in Cohen (1988).
}
\details{
The conversion is defined as:
\deqn{f = \sqrt{\eta_p^2 / (1 - \eta_p^2)}}

This follows from the inverse relationship:
\deqn{\eta_p^2 = \frac{f^2}{1 + f^2}}
}
\examples{
# Convert a single partial eta squared value
peta2_to_cohensf(0.06)

# Convert multiple values
peta2_to_cohensf(c(0.01, 0.06, 0.14))

}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.).
Hillsdale, NJ: Lawrence Erlbaum Associates.
}
\seealso{
\link{cohensf_to_peta2}
}
