% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluck-depth.R
\name{pluck_depth}
\alias{pluck_depth}
\alias{vec_depth}
\title{Compute the depth of a vector}
\usage{
pluck_depth(x, is_node = NULL)
}
\arguments{
\item{x}{A vector}

\item{is_node}{Optionally override the default criteria for determine an
element can be recursed within. The default matches the behaviour of
\code{pluck()} which can recurse into lists and expressions.}
}
\value{
An integer.
}
\description{
The depth of a vector is how many levels that you can index/pluck into it.
\code{pluck_depth()} was previously called \code{vec_depth()}.
}
\examples{
x <- list(
  list(),
  list(list()),
  list(list(list(1)))
)
pluck_depth(x)
x |> map_int(pluck_depth)
}
