% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pureseqtm_proteome.R
\name{run_pureseqtm_proteome}
\alias{run_pureseqtm_proteome}
\title{Run PureseqTM on a proteome}
\usage{
run_pureseqtm_proteome(
  fasta_filename,
  folder_name = get_default_pureseqtm_folder(),
  topology_filename = tempfile(fileext = ".top")
)
}
\arguments{
\item{fasta_filename}{path to a FASTA file}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}

\item{topology_filename}{name of the file to save a protein's
topology to}
}
\value{
the topology of the proteome, using the same output as PureseqTM.
Use \link{predict_topology} to get the topology as a \link[tibble]{tibble}
}
\description{
Run PureseqTM on a proteome
}
\examples{
if (is_pureseqtm_installed()) {
  fasta_filename <- get_example_filename("1bhaA.fasta")
  run_pureseqtm_proteome(fasta_filename)
}
}
\seealso{
\itemize{
\item{
Use \link{predict_topology} to predict the topology
of a proteome
}
\item{
Use \link{create_pureseqtm_files} to only create the PureseqTM
output files
}
}
}
\author{
Richèl J.C. Bilderbeek
}
