% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_tmhmm_to_pureseqtm_topology.R
\name{convert_tmhmm_to_pureseqtm_topology}
\alias{convert_tmhmm_to_pureseqtm_topology}
\title{Convert a TMHMM topology to a PureseqTM topology}
\usage{
convert_tmhmm_to_pureseqtm_topology(tmhmm_topology)
}
\arguments{
\item{tmhmm_topology}{topology as used by \code{TMHMM}}
}
\value{
a \link[tibble]{tibble} with column names
\code{name} and \code{topology}, as can be checked by \link{check_topology}
}
\description{
Convert a TMHMM topology to a PureseqTM topology
}
\examples{
tmhmm_topo_filename <- system.file(
  "extdata", "UP000005640_9606_no_u.tmhmm", package = "pureseqtmr"
)
tmhmm_topology <- load_topology_file_as_tibble(tmhmm_topo_filename)
convert_tmhmm_to_pureseqtm_topology(tmhmm_topology)
}
\author{
Richèl J.C. Bilderbeek
}
