% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_protein_sequences.R
\name{check_protein_sequences}
\alias{check_protein_sequences}
\title{Check one or more protein sequences}
\usage{
check_protein_sequences(protein_sequences)
}
\arguments{
\item{protein_sequences}{one ore more protein sequence,
each sequence with the amino acids as capitals, for
example \code{MEILCEDNTSLSSIPNSL}}
}
\value{
nothing.
Will \link{stop} at the first invalid protein sequence,
with a helpful error message.
}
\description{
Will \link{stop} if the protein sequence is invalid,
with a helpful error message.
}
\details{
A protein sequence is invalid if:
\itemize{
\item it has zero, two or more sequences
\item the sequence contains zero, 1 or 2 amino acids
\item the sequence contains characters that are not in the
amino acid uppercase alphabet,
that is \code{ACDEFGHIKLMNPQRSTVWY}
}
}
\examples{
check_protein_sequences(c("FAMILYVW", "FAMILYVW"))
}
