% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{faceted_time_series_plot}
\alias{faceted_time_series_plot}
\title{Faceted Time Series Plot of Methane Concentrations and Wind Data}
\usage{
faceted_time_series_plot(
  sensor_concentrations,
  sensor_coords,
  wind_data,
  start_time,
  end_time,
  output_dt,
  text_size = 12
)
}
\arguments{
\item{sensor_concentrations}{Data frame. Output from simulate_sensor_mode().}

\item{sensor_coords}{A data frame or matrix containing sensor locations.}

\item{wind_data}{A list with wind_u and wind_v components.}

\item{start_time}{POSIXct start of simulation.}

\item{end_time}{POSIXct end of simulation.}

\item{output_dt}{Time step (in seconds) for aligning wind data with concentration data.}

\item{text_size}{Default at 12.}
}
\value{
A ggplot object: faceted concentration plot + single wind rose plot.
}
\description{
This function creates a faceted bubble plot of methane concentrations and a shared wind rose plot.
}
\examples{
set.seed(123)
sim_dt <- 10
puff_dt <- 10
output_dt <- 60
start_time <- "2024-01-01 12:00:00"
end_time <- "2024-01-01 13:00:00"
emission_rate <- 3.5
wind_data <- data.frame(
  wind_u = runif(3601, min = -3, max = 0.7),
  wind_v = runif(3601, min = -3, max = 1.5)
)
source_coords <- c(0, 0, 2.5)
sensor_coords <- matrix(c(-6.525403221327715e-15, -35.52264, 2.01775), ncol = 3, byrow = TRUE)

out <- simulate_sensor_mode(
  start_time, end_time, source_coords,
  emission_rate, wind_data, sensor_coords, sim_dt, puff_dt, output_dt, puff_duration = 1200
)

faceted_time_series_plot(out, sensor_coords,
  wind_data, as.POSIXct(start_time), as.POSIXct(end_time),
  output_dt
  )
}
