% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recForcast.R
\name{recForcast}
\alias{recForcast}
\title{Estimating recruitment rates based on the number of sites and average site
recruitment rates.}
\usage{
recForcast(N.site, rpm, open.rate, Max.Time, penal = 0.5, plot = TRUE, ...)
}
\arguments{
\item{N.site}{The number of recruiting sites}

\item{rpm}{The average recruitment per site per month}

\item{open.rate}{the rate at which sites are expected to open to recruitment}

\item{Max.Time}{maximum time used in the estimation}

\item{penal}{A penalising factor for the recruitment in the intial month for
each site (defaults to penal=0.5)}

\item{plot}{shoud results be plotted?}

\item{...}{aditional arguments passed to plot}
}
\value{
A dataset giving the monthly recruitment rate
}
\description{
Estimating recruitment rates based on the number of sites and average site
recruitment rates.
}
\details{
This functions estimates monthly recruitment rates based on the number of
sites and the average monthly recruitment rate.  The resulting dataset can be
passed to pscDesign to improve estimation of design parameters.
}
\examples{
recForcast(N.site=5,rpm=1,open.rate=1,Max.Time=12)
}
