% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smooth.R
\name{hmm_smooth}
\alias{hmm_smooth}
\title{hmm_smooth}
\usage{
hmm_smooth(hmm, sw = 7)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}

\item{sw}{The size of the sliding window.}
}
\value{
A matrix of dimensions L \eqn{\times} 20.
}
\description{
This feature smooths the HMM matrix \eqn{H} by using sliding window of length \eqn{sw} to incorporate information
from up and downstream residues into each row of the HMM matrix. Each HMM row \eqn{r_i} is made into the summation
of \eqn{r_{i-(sw/2)}+... r_i...+r_{i+(sw/2)}}, for \eqn{i = 1:L}, where \eqn{L} is the number of rows in \eqn{H}.
For rows such as the beginning and ending rows, \eqn{0} matrices of dimensions \eqn{sw/2, 20} are appended to the
original matrix \eqn{H}.
}
\examples{
h<- hmm_smooth(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Fang, C., Noguchi, T., & Yamana, H. (2013).
SCPSSMpred: A General Sequence-based Method for Ligand-binding Site Prediction.
IPSJ Transactions on Bioinformatics, 6(0), 35–42.
}
