% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance.R
\name{hmm_distance}
\alias{hmm_distance}
\title{hmm_distance}
\usage{
hmm_distance(hmm_1, hmm_2)
}
\arguments{
\item{hmm_1}{The name of a profile hidden markov model file.}

\item{hmm_2}{The name of another profile hidden markov model file.}
}
\value{
A double that indicates distance between the two proteins.
}
\description{
This feature calculates the cosine distance matrix between two HMMs \eqn{A} and \eqn{B} before dynamic time warp is applied to
the distance matrix calculate the cumulative distance between the HMMs, which acts as a measure of similarity,
The cosine distance matrix \eqn{D} is found to be \eqn{D[a_i, b_j] = 1 - \frac{a_ib_j^{T}}{a_ia_i^Tb_jb_j^T}},
in which \eqn{a_i} and \eqn{a_i} refer to row vectors of \eqn{A} and \eqn{B} respectively.
This in turn means that \eqn{D} is of dimensions \eqn{nrow(A), nrow(b)}. Dynamic time warp then calculates the
cumulative distance by calculating matrix \eqn{C[i, j] = min(C[i-1, j], C[i, j-1], C[i-1, j-1]) + D[i, j]},
where \eqn{C_{i,j}} is 0 when \eqn{i} or \eqn{j} are less than 1. The lower rightmost point of the matrix \eqn{C}
is then returned as the cumulative distance between proteins.
}
\examples{
h<- hmm_distance(system.file("extdata", "1DLHA2-7", package="protHMM"),
system.file("extdata", "1TEN-7", package="protHMM"))
}
\references{
Lyons, J., Paliwal, K. K., Dehzangi, A., Heffernan, R., Tsunoda, T., & Sharma, A. (2016).
Protein fold recognition using HMM–HMM alignment and dynamic programming.
Journal of Theoretical Biology, 393, 67–74.
}
