% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.properties.R
\name{write.properties}
\alias{write.properties}
\title{Write a Java Properties File}
\usage{
write.properties(file, properties, fields = NULL, encoding = "UTF-8")
}
\arguments{
\item{file}{properties file, either a character string (path) or a connection}

\item{properties}{list with key-value pairs}

\item{fields}{subset of field names, if NULL, all fields are included}

\item{encoding}{encoding of the properties file to read (default value \code{"UTF-8"})}
}
\value{
nothing; the properties are written to file
}
\description{
Write a Java Properties File
}
\examples{
tf <- tempfile()
write.properties(file = tf,
    properties = list(key1 = "value1", key2 = "value2", key3 = "value3"),
    fields = c("key2", "key3"))
unlink(tf)
}
\seealso{
\code{\link{read.properties}} for reading properties files
}
\author{
Daan Seynaeve
}
