% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_probe_func.R
\name{predict_probe_func}
\alias{predict_probe_func}
\title{Obtaining predictions, confidence intervals and prediction intervals from probe}
\usage{
predict_probe_func(res, X, Z = NULL, alpha = 0.05, X_2 = NULL)
}
\arguments{
\item{res}{The results from the probe function.}

\item{X}{A matrix containing the predictors on which to apply the probe algorithm}

\item{Z}{(optional) A matrix or dataframe of predictors not subjected to the sparsity assumption to account for.}

\item{alpha}{significance level for (\eqn{100(1-\alpha)\%}) credible and prediction intervals.}

\item{X_2}{(optional) Square of X matrix.}
}
\value{
A dataframe with predictions, credible intervals, and prediction intervals for each new observation.
}
\description{
A function providing predictions, along with \eqn{(1-\alpha)*100\%} credible, and prediction intervals for new observations.
}
\examples{
### Example
data(Sim_data)
data(Sim_data_test)
attach(Sim_data)
attach(Sim_data_test)
alpha <- 0.05
plot_ind <- TRUE
adj <- 10

# Run the analysis. Y_test and X_test are included for plotting purposes only
full_res <- probe( Y = Y, X = X, Y_test = Y_test, 
X_test = X_test, alpha = alpha, plot_ind = plot_ind, adj = adj)

# Predicting for test data
pred_res <- predict_probe_func(full_res, X = X_test, alpha = alpha)
sqrt(mean((Y_test - pred_res$Pred)^2))
head(pred_res)

}
\references{
McLain, A. C., Zgodic, A., & Bondell, H. (2022). Sparse high-dimensional linear regression with a partitioned empirical Bayes ECM algorithm. arXiv preprint arXiv:2209.08139.
Zgodic, A., Bai, R., Zhang, J., Wang, Y., Rorden, C., & McLain, A. (2023). Heteroscedastic sparse high-dimensional linear regression with a partitioned empirical Bayes ECM algorithm. arXiv preprint arXiv:2309.08783.
}
