% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_step_func.R
\name{e_step_func}
\alias{e_step_func}
\title{Function for fitting the empirical Bayes portion of the E-step}
\usage{
e_step_func(beta_t, beta_var, df, adj = 5, lambda = 0.1, monotone = TRUE)
}
\arguments{
\item{beta_t}{Expectation of the posterior mean (assuming \eqn{\gamma=1})}

\item{beta_var}{Current posterior variance (assuming \eqn{\gamma=1})}

\item{df}{Degrees of freedom for the t-distribution (use to calculate p-values).}

\item{adj}{Bandwidth multiplier to Silverman's `rule of thumb' for calculating the marginal density of the test-statistics (default = 5).}

\item{lambda}{Value of the \eqn{\lambda} parameter for estimating the proportion of null hypothesis using Storey et al. (2004) (default = 0.1).}

\item{monotone}{Logical - Should the estimated marginal density of the test-statistics be monotone non-increasing from zero (default = TRUE).}
}
\value{
A list including 

\code{delta} estimated posterior expectations of the \eqn{\gamma}.

\code{pi0} estimated proportion of null hypothesis
}
\description{
A wrapper function estimating posterior expectations of the \eqn{\gamma} variables using an empirical Bayesian technqiue.
}
\references{
Storey, J. D., Taylor, J. E., and Siegmund, D. (2004), “Strong control, conservative point estimation and simultaneous conservative consistency of false discovery rates: A unified approach,” J. R. Stat. Soc. Ser. B. Stat. Methodol., 66, 187–205.
McLain, A. C., Zgodic, A., & Bondell, H. (2022). Sparse high-dimensional linear regression with a partitioned empirical Bayes ECM algorithm. arXiv preprint arXiv:2209.08139.
}
