% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlogistic.R
\name{dlogistic}
\alias{dlogistic}
\title{Discrete Logistic Growth}
\usage{
dlogistic(t, y, p)
}
\arguments{
\item{t}{times points that will return N}

\item{y}{N}

\item{p}{a vector of labeled logistic growth parameters; the first must be labeled rd, and the second must be labeled alpha (the value of alpha is 1/K).}
}
\value{
Returns of list of one component (required by \code{ode}).
}
\description{
Single species discrete logistic growth -- a difference equation.
A function for continuous logistic growth, for use with \code{ode} in the
\code{deSolve} package, using method = 'euler' and integer time steps.
}
\details{
Of the form,
\deqn{N_{t+1} - N_{t} = r_d N_{t}\left(1 - \alpha N_{t}\right)}
}
\examples{

library(deSolve)
# MUST use the 'euler' integration method with integer time steps
p <- c(rd=1, alpha=.01)
time <- 0:10
initialN <- 10
out <- ode(y=initialN, times=time,
             func=dlogistic, parms=p, method='euler')
plot(time, out[,-1], type='l')

}
\references{
Stevens. M.H.H. (2009) \emph{A Primer of Ecology with R}. Use R!
Series. Springer.
}
\seealso{
\code{\link{clogistic}}, \code{\link{lvcompg}}
}
\author{
Hank Stevens (HankStevens@miamioh.edu)
}
\keyword{methods}
