% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predReliability.r
\name{predReliability}
\alias{predReliability}
\title{A reliability function}
\usage{
predReliability(
  data.test,
  data.train,
  types,
  formula,
  model.function,
  predict.function,
  ceval = F,
  nThread = 1,
  ...
)
}
\arguments{
\item{data.test}{a \code{\link[base]{data.frame}} object used as the testing data for your prediction model}

\item{data.train}{a \code{\link[base]{data.frame}} object used as the training data for your prediction model}

\item{types}{a \code{\link[base]{vector}} of reliability test types you want to perform c("bagv", "cnk", "lcv", "sa")}

\item{formula}{a \code{\link[stats]{formula}} describing the model to be fitted}

\item{model.function}{a function with arguments \code{\link[stats]{formula}} and \code{\link[base]{data.frame}} implementing the predictive model to be evaluated. The function model must return an onject representing a fitted model.}

\item{predict.function}{a function with arguments model object \code{\link[base]{data.frame}} of testing instances that will be predicted based on the given model.}

\item{ceval}{a flag whether a 10-fold correlation test should be made on the requested types (default set to false)}

\item{nThread}{the number}

\item{...}{extra arguments you wish to be passed to your model and prediction function}
}
\description{
A function used to calculate the reliability of individual predictions given by your model and prediction function with methods described in the paper (Bosnic, Z., & Kononenko, I. (2008) <doi:10.1007/s10489-007-0084-9>). It also allows you to make a correlation test to estimate which reliability estimate is the most accurate for your model.
}
\examples{

estimates <- c("bagv", "cnk", "lcv", "sa")
predReliability(mtcars[1,], mtcars[-1,], estimates, mpg~., rpart::rpart, predict)
}
\references{
Bosnic, Z., & Kononenko, I. (2008). Comparison of approaches for estimating reliability of individual regression predictions. Data & Knowledge Engineering, 67(3), 504-516.
Bosnic, Z., & Kononenko, I. (2008). Estimation of individual prediction reliability using the local sensitivity analysis. Applied intelligence, 29(3), 187-203.
Bosnic, Z., & Kononenko, I. (2009). An overview of advances in reliability estimation of individual predictions in machine learning. Intelligent Data Analysis, 13(2), 385-401.
}
\keyword{predReliability}
