% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpexpow.R, R/prpexpow.R, R/qrpexpow.R,
%   R/rrpexpow.R
\name{ReversalPowerExponentialPower}
\alias{ReversalPowerExponentialPower}
\alias{drpexpow}
\alias{ReversalPowerExponentialPower}
\alias{prpexpow}
\alias{ReversalPowerExponentialPower}
\alias{qrpexpow}
\alias{ReversalPowerExponentialPower}
\alias{rrpexpow}
\title{The Reversal Power Exponential Power Distribution}
\usage{
drpexpow(x, lambda = 1, mu = 0, sigma = 1, k = 0, log = FALSE)

prpexpow(q, lambda = 1, mu = 0, sigma = 1, k = 0, lower.tail = TRUE,
  log.p = FALSE)

qrpexpow(p, lambda = 1, mu = 0, sigma = 1, k = 0, lower.tail = TRUE,
  log.p = FALSE)

rrpexpow(n, lambda = 1, mu = 0, sigma = 1, k = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters.}

\item{k, lambda}{shape parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power exponential power distribution with parameters mu, sigma, lambda and k.
}
\details{
The reversal power exponential power distribution has density

\eqn{f(x)=[\lambda/\sigma][f((x-\mu)/\sigma)][F((x-\mu)/\sigma)] ^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} and k the shape parameters.
}
\examples{
drpexpow(1, 1, 3, 4, 1)
prpexpow(1, 1, 3, 4, 1)
qrpexpow(0.2, 1, 3, 4, 1)
rrpexpow(5, 2, 3, 4, 1)
}
