% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplogis.R, R/pplogis.R, R/qplogis.R,
%   R/rplogis.R
\name{PowerLogistic}
\alias{PowerLogistic}
\alias{dplogis}
\alias{PowerLogistic}
\alias{pplogis}
\alias{PowerLogistic}
\alias{qplogis}
\alias{PowerLogistic}
\alias{rplogis}
\title{The Power Logistic Distribution}
\usage{
dplogis(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

pplogis(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qplogis(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rplogis(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power logistic distribution with parameters mu, sigma and lambda.
}
\details{
The power Logistic distribution has density

\eqn{f(x)=\lambda \left [\frac{1}{1+e^{-\left ( \frac{x-\mu}{\sigma} \right )} }\right ]^{\lambda-1}\left[\frac{ e^{-\left ( \frac{x-\mu}{\sigma} \right )} }{\sigma\left ( 1+e^{-\left ( \frac{x-\mu}{\sigma} \right )}   \right )^2}\right]}{f(x)=[\lambda/\sigma][exp(-(x-\mu)/\sigma)/(1+exp(-(x-\mu)/\sigma)))^2][exp((x-\mu)/\sigma)/(1+exp((x-\mu)/\sigma)]^(\lambda-1)},
where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
dplogis(1, 1, 3, 4)
pplogis(1, 1, 3, 4)
qplogis(0.2, 1, 3, 4)
rplogis(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{https://repositorio.ufscar.br/handle/ufscar/9016}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 16. Wiley, New York.

Lemonte, A. J. and Bazán, J. L. (2017) New links for binary regression: an application to coca cultivation in Peru. \emph{TEST}.

Nadarajah, S. (2009) The skew logistic distribution. \emph{AStA Advances in Statistical Analysis}, \strong{93}, 187-203.

Prentice, R. L. (1976) A Generalization of the probit and logit methods for dose-response curves. \emph{Biometrika}, \strong{32}, 761-768.
}
