% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_var_sexgender}
\alias{find_var_sexgender}
\title{Identify a Sex or Gender Variable}
\usage{
find_var_sexgender(nms)
}
\arguments{
\item{nms}{A character vector}
}
\value{
An element of \code{nms}, or \code{NULL}.
}
\description{
Find the element of \code{nms} that looks like
a sex or gender variable.
If no elements look like a sex or gender variable,
or if two or more elements do,
then return \code{NULL}.
}
\examples{
find_var_sexgender(c("Sex", "Year", "AgeGroup", NA)) ## one valid
find_var_sexgender(c("Age", "Region"))               ## none valid
find_var_sexgender(c("sexgender", "sexes"))          ## two valid
}
\seealso{
\code{\link[=find_var_age]{find_var_age()}}, \code{\link[=find_var_time]{find_var_time()}}, \code{\link[=find_label_female]{find_label_female()}},
\code{\link[=find_label_male]{find_label_male()}}
}
