% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectionD.R
\name{projectionD}
\alias{projectionD}
\title{Calculate projection distance}
\usage{
projectionD(A, vector)
}
\arguments{
\item{A}{a square, irreducible, non-negative numeric matrix of any dimension.}

\item{vector}{a numeric vector or one-column matrix describing the age/stage 
distribution used to calculate the distance.}
}
\value{
Projection distance.
}
\description{
Calculate projection distance for a population matrix projection model.
}
\details{
\code{projectionD} (Haridas & Tuljapurkar 2007) is the difference 
between the reproductive value of a population with demographic distribution 
given by \code{vector} and the reproductive value of a population in stable 
state.

\code{projectionD} will not work for reducible matrices and returns a 
warning for imprimitive matrices (although will not function for imprimitive 
matrices with nonzero imaginary components in the dominant eigenpair).
}
\examples{
  # Create a 3x3 PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Create an initial stage structure
  ( initial <- c(1,3,2) )

  # Calculate projection distance
  projectionD(A, vector=initial)

}
\references{
\itemize{
 \item Haridas & Tuljapurkar (2007) Ecol. Lett., 10, 1143-1153.
 \item Stott et al. (2011) Ecol. Lett., 14, 959-970.
}
}
\seealso{
Other DistanceMeasures: 
\code{\link{CohenD}()},
\code{\link{KeyfitzD}()}
}
\concept{DistanceMeasures}
\concept{distance vector}
