% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nipals.fit.R
\name{nipals.fit}
\alias{nipals.fit}
\title{NIPALS PLS with missing values}
\usage{
nipals.fit(
  X,
  Y,
  ncomp,
  center = TRUE,
  stripped = FALSE,
  maxiter = 500,
  tol = 1e-06,
  ...
)
}
\arguments{
\item{X}{numeric matrix (or coercible) of predictors. Missing values are
allowed and handled internally.}

\item{Y}{numeric matrix (or coercible) of responses. Missing values are also
handled internally.}

\item{ncomp}{number of PLS components to extract.}

\item{center}{logical whether to center \code{X} and \code{Y} before
fitting. Means ignore missing entries.}

\item{stripped}{logical. If \code{TRUE} only the coefficients and the mean
vectors are returned.}

\item{maxiter}{maximum number of inner iterations to force convergence on
each component.}

\item{tol}{tolerance used to stop the inner loop when the direction vector
changes very little.}

\item{...}{currently ignored.}
}
\value{
A list with the same components as \code{nipals.fit}, but the
computations never fail in the presence of missing entries.
}
\description{
A NIPALS implementation that tolerates \code{NA}s in both
\code{X} and \code{Y} by ignoring them when updating scores and loadings.
This is useful when the design matrix is incomplete but the number of
components is relatively low.
}
