% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityplot.R
\name{DensityHistoPlotAtomic}
\alias{DensityHistoPlotAtomic}
\title{Atomic density/histogram plot}
\usage{
DensityHistoPlotAtomic(
  data,
  x,
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  xtrans = "identity",
  ytrans = "identity",
  type = c("density", "histogram"),
  bins = NULL,
  binwidth = NULL,
  flip = FALSE,
  keep_na = FALSE,
  keep_empty = FALSE,
  add_bars = FALSE,
  bar_height = 0.025,
  bar_alpha = 1,
  bar_width = 0.1,
  position = "identity",
  use_trend = FALSE,
  add_trend = FALSE,
  trend_alpha = 1,
  trend_linewidth = 0.8,
  trend_pt_size = 1.5,
  trend_skip_zero = FALSE,
  palette = "Paired",
  palcolor = NULL,
  alpha = 0.5,
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  expand = c(bottom = 0, left = 0, right = 0),
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  legend.position = ifelse(is.null(group_by), "none", "right"),
  legend.direction = "vertical",
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string specifying the column name for the values
A numeric column is expected.}

\item{group_by}{A character string specifying the column name to group the data}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by} if multiple columns are provided}

\item{group_name}{A character string to name the legend of group_by}

\item{xtrans}{A character string specifying the transformation of the x-axis. Default is "identity".
Other options see transform of \code{\link[ggplot2]{scale_x_continuous}}.}

\item{ytrans}{A character string specifying the transformation of the y-axis. Default is "identity".
Other options see transform of \code{\link[ggplot2]{scale_y_continuous}}.}

\item{type}{A character string specifying the type of plot. Default is "density".
Other options are "histogram".}

\item{bins}{A numeric value specifying the number of bins for the histogram.}

\item{binwidth}{A numeric value specifying the width of the bins for the histogram.}

\item{flip}{A logical value. If TRUE, the plot will be flipped.}

\item{keep_na}{A logical value or a character to replace the NA values in the data.
It can also take a named list to specify different behavior for different columns.
If TRUE or NA, NA values will be replaced with NA.
If FALSE, NA values will be removed from the data before plotting.
If a character string is provided, NA values will be replaced with the provided string.
If a named vector/list is provided, the names should be the column names to apply the behavior to,
and the values should be one of TRUE, FALSE, or a character string.
Without a named vector/list, the behavior applies to categorical/character columns used on the plot,
for example, the \code{x}, \code{group_by}, \code{fill_by}, etc.}

\item{keep_empty}{One of FALSE, TRUE and "level". It can also take a named list to specify
different behavior for different columns. Without a named list, the behavior applies to the
categorical/character columns used on the plot, for example, the \code{x}, \code{group_by}, \code{fill_by}, etc.
\itemize{
\item{\code{FALSE} (default): Drop empty factor levels from the data before plotting.}
\item{\code{TRUE}: Keep empty factor levels and show them as a separate category in the plot.}
\item{\code{"level"}: Keep empty factor levels, but do not show them in the plot.
But they will be assigned colors from the palette to maintain consistency across multiple plots.
Alias: \code{levels}}
}}

\item{add_bars}{A logical value. If TRUE, add lines to the plot to show the data distribution on the bottom.}

\item{bar_height}{A numeric value specifying the height of the bars. The actual height will be calculated based on the maximum density or count.}

\item{bar_alpha}{A numeric value specifying the alpha of the bars.}

\item{bar_width}{A numeric value specifying the width of the bars.}

\item{position}{How should we position the values in each bin? Default is "identity".
Unlike the default position = "stack" in \link[ggplot2:geom_histogram]{ggplot2::geom_histogram} or \link[ggplot2:geom_density]{ggplot2::geom_density},
the default position is "identity" to show the actual count or density for each group.}

\item{use_trend}{A logical value. If TRUE, use trend line instead of histogram.}

\item{add_trend}{A logical value. If TRUE, add trend line to the histogram.}

\item{trend_alpha}{A numeric value specifying the alpha of the trend line and points}

\item{trend_linewidth}{A numeric value specifying the width of the trend line}

\item{trend_pt_size}{A numeric value specifying the size of the trend points}

\item{trend_skip_zero}{A logical value. If TRUE, skip the zero count when drawing the trend line.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{expand}{The values to expand the x and y axes. It is like CSS padding.
When a single value is provided, it is used for both axes on both sides.
When two values are provided, the first value is used for the top/bottom side and the second value is used for the left/right side.
When three values are provided, the first value is used for the top side, the second value is used for the left/right side, and the third value is used for the bottom side.
When four values are provided, the values are used for the top, right, bottom, and left sides, respectively.
You can also use a named vector to specify the values for each side.
When the axis is discrete, the values will be applied as 'add' to the 'expansion' function.
When the axis is continuous, the values will be applied as 'mult' to the 'expansion' function.
See also \url{https://ggplot2.tidyverse.org/reference/expansion.html}}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{...}{Additional arguments.}
}
\description{
Atomic density/histogram plot
}
\keyword{internal}
