% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{shapefile_edit}
\alias{shapefile_edit}
\title{Edit Features in a Shapefile}
\usage{
shapefile_edit(
  shapefile,
  mosaic = NULL,
  basemap = NULL,
  r = 3,
  g = 2,
  b = 1,
  max_pixels = 3e+06
)
}
\arguments{
\item{shapefile}{A shapefile (\code{sf} object) that can be created with
\code{\link[=shapefile_input]{shapefile_input()}}.}

\item{mosaic}{Optionally, a mosaic (SpatRaster) to be displayed as a
background.}

\item{basemap}{An optional \code{mapview} object.}

\item{r}{Red band index for RGB display (default is 3).}

\item{g}{Green band index for RGB display (default is 2).}

\item{b}{Blue band index for RGB display (default is 1).}

\item{max_pixels}{Maximum number of pixels for down-sampling the mosaic
(default is 3e6).}
}
\value{
A modified shapefile with user-edited features.
}
\description{
This function allows you to interactively edit features in a shapefile using
the mapedit package.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
shp <- shapefile_input(system.file("ex/lux.shp", package="terra"))
edited <- shapefile_edit(shp)
}
}
