% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{SimpleLogger}
\alias{SimpleLogger}
\title{Simple Logger Class}
\description{
A minimal logging class using only base R functions.
Provides threshold-based logging with INFO, WARN, and FATAL levels.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SimpleLogger-new}{\code{SimpleLogger$new()}}
\item \href{#method-SimpleLogger-info}{\code{SimpleLogger$info()}}
\item \href{#method-SimpleLogger-warn}{\code{SimpleLogger$warn()}}
\item \href{#method-SimpleLogger-fatal}{\code{SimpleLogger$fatal()}}
\item \href{#method-SimpleLogger-get_threshold}{\code{SimpleLogger$get_threshold()}}
\item \href{#method-SimpleLogger-set_threshold}{\code{SimpleLogger$set_threshold()}}
\item \href{#method-SimpleLogger-clone}{\code{SimpleLogger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-new"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new SimpleLogger
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$new(threshold = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{Initial threshold level (default: 0 for silent)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new SimpleLogger instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-info"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-info}{}}}
\subsection{Method \code{info()}}{
Log an informational message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$info(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Message to log}

\item{\code{...}}{Additional arguments (currently ignored)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-warn"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-warn}{}}}
\subsection{Method \code{warn()}}{
Log a warning message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$warn(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Message to log}

\item{\code{...}}{Additional arguments (currently ignored)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-fatal"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-fatal}{}}}
\subsection{Method \code{fatal()}}{
Log a fatal error message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$fatal(msg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Message to log}

\item{\code{...}}{Additional arguments (currently ignored)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-get_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-get_threshold}{}}}
\subsection{Method \code{get_threshold()}}{
Get current threshold
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$get_threshold()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Current threshold value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-set_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-set_threshold}{}}}
\subsection{Method \code{set_threshold()}}{
Set threshold level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$set_threshold(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{Threshold level (0 = silent, 4 = INFO, 5 = WARN, 6 = FATAL)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimpleLogger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimpleLogger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleLogger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
