% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pasteBoxInput.R
\name{pasteBoxInput}
\alias{pasteBoxInput}
\title{Paste Box Input}
\usage{
pasteBoxInput(inputId, label, width = "100px", height = "100px")
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control.}

\item{width}{The width of the paste box, e.g., '100px'.}

\item{height}{The height of the paste box, e.g., '100px'.}
}
\value{
A Shiny tag list that creates a UI element for pasting images.
}
\description{
Create a paste box input control for images.
}
\examples{
if (interactive()) {
  library(shiny)
  library(base64enc)

  ui <- fluidPage(
    pasteBoxInput("testInput", "Paste Image Here", "300px", "150px"),
    uiOutput("image")
  )

  server <- function(input, output, session) {

  #This example is to show how to render the image directly back to the user
    observeEvent(input$testInput, {
      if (!is.null(input$testInput) && input$testInput != "") {
        output$image <- renderUI({
          tags$img(src = input$testInput, style = "max-width: 100\%; height: auto;")
        })
      }
    })

    #This example is to show how to save the image, in this case to a temp file.
    observeEvent(input$testInput, {
      if (!is.null(input$testInput) && input$testInput != "") {

      if (grepl("^data:image", input$testInput)) {
        base64_string <- sub("data:image/[a-z]+;base64,", "", input$testInput)
        }
        decoded_data <- base64decode(base64_string)

        temp_file_name <- tempfile(fileext = ".png")

        writeBin(as.raw(decoded_data), temp_file_name)
        }

        })

  }
  shinyApp(ui, server)
}

}
