% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covmat.check.R
\name{covmat.check}
\alias{covmat.check}
\title{covmat.check}
\usage{
covmat.check(mat)
}
\arguments{
\item{mat}{A putative covariance matrix.}
}
\value{
A data.frame containing logical "TRUE" or "FALSE" for each condition.
}
\description{
Tets for validity of a covariance matrix based on four conditions:
symmetry, diagonal dominance, positive definiteness, and positive variance.
}
\details{
A valid covariance matrix must be symmetric, diagonally dominant (largest values
in each row are on the diagonal), positive definite, and have positive variance.
\code{covmat.check} takes a matrix as input and tests for these four conditions.
}
\examples{
# Load sample covariance matrix
data(sim.cov.pairs)
# Test for validity
covmat.check(sim.cov.pairs)
}
