% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_results.R
\name{nls_results}
\alias{nls_results}
\title{Array of Results from all NLS Models eq1-eq11}
\usage{
nls_results(
    data,
    species_col,
    sample_col,
    A_col,
    specs = NULL,
    dat_wide = NULL,
    PARi = c(0, 50, 100, 250, 500, 1000, 1500, 2000, 2500),
    PARi_fine = seq(0,6000,by = .1),
    eqs = paste("eq", c(1, 2, 3, 4, 5, 6, 8, 9, 11), sep = ""),
    par_names = c("Pgmax", "Pmax", "phi_I0", "phi_I0_Icomp", "phi_Icomp",
                   "phi_Icomp_200", "Rd", "Icomp", "Isat", "Isat_25",
                   "Isat_50", "Isat_75", "Isat_85", "Isat_90", "Isat_95",
                   "I5", "I10", "I15", "I25", "I50", "I75", "I85", "I90",
                   "I95", "Imax", "Imax_obs", "P_Imax",
                   "beta", "gamma", "theta", "k"))
}
\arguments{
\item{data}{A data frame of measured input data with a column
for each unique plant observed, a column to indicate a common identifier
among each unique observation a column of light intensities at measured
PARi values, and a column for measured measured carbon assimilation
values.}

\item{species_col}{Identify the column in your data set for the Species
name, or the common identifier for each sample (Ex. H.Debilis)}

\item{sample_col}{Identify the column in your data set with the Sample ID,
or the unique identifier for each observation (Ex. H.Debilis_2_Oct1).}

\item{A_col}{Identify the column in your data set corresponding to the
measured carbon assimilation value (A).}

\item{specs}{A character or factor vector to subset individual identifiers,
defaults to all unique samples in the data set.}

\item{dat_wide}{A wide-format data frame used to extract observed \code{PARi} and
\code{A} values for each \code{Species} and \code{Sample} taken, defaults to
transform \code{dat_wide} from \code{data} automatically.}

\item{PARi}{A numeric vector of \code{PARi} values in which carbon assimilation
was measured.
Defaults to c(0, 50, 100, 250, 500, 1000, 1500, 2000, 2500).}

\item{PARi_fine}{A finer numeric vector of \code{PARi} values for estimating
response across a continuous light range, defaults to seq(0,6000,by = .1)
for fine scale predictions.}

\item{eqs}{A character vector of equation names to be fitted. Defaults to the
9 equations programmed in this package:
(\code{eq1}, \code{eq2}, \code{eq3}, \code{eq4}, \code{eq5}, \code{eq6}, \code{eq8}, \code{eq9}, \code{eq11}).}

\item{par_names}{A character or factor vector of parameters calculated from
the NLS models to include in the array of results. Defaults to parameters
calculated from all 9 models in this package unless otherwise specified.}
}
\value{
A list containing the following elements:
\describe{
\item{res}{An array of results. The array dimensions are:
number of photosynthetic models (eq) tested x
(number of parameters + 2 * length(PARi)) x length(inds).}
\item{fitted_curves}{A list of fitted curves for each equation and
individual.}
\item{r2}{A matrix of \code{r2} values for each individual and equation.}
\item{mse}{A matrix of \code{mse} values for each individual and equation.}
}
}
\description{
This function generates an array of results from the NLS models
presented in Lobo et al. (2013) and Davis et al. (2024). The array
includes all calculated values/model parameters for each NLS model (eq),
predicted values of the NLS curve, and goodness of fit statistics -
mean squared error (MSE) and r2 values- for each predicted curve and
calculated value.
}
\details{
The function fits each equation from the \code{eqs} list to the subset
of \code{data} corresponding to each unique sample. It then returns
calculated parameters, predicted values, and observed \code{PARi} values for
the given individual(s). The results are stored in an array, and the
goodness-of-fit metrics (\code{r2} and \code{mse}) are saved in separate matrices.
}
\examples{
# Example dataset
data(sunflowers)
data <- sunflowers |>filter(SampleID==SampleID)

# Specify arguments
PARi = c(0, 50, 100, 250, 500, 1000, 1500, 2000, 2500)
PARifine <- seq(0, 1500, by = 1)
par_names <- c("Pmax", "Icomp", "phi_Icomp", "Rd", "I15, I25", "I85", "I95")
dat_wide <- data \%>\% pivot_wider(id_cols = c(Species,SampleID),
                                 names_from = PARi, names_prefix = "PARi_",values_from = A)
subset <- first_five <- unique(data$SampleID[1:43])

# Process light response curve data for all model equations
my_results <- nls_results(data = data, species_col = "Species",
                          sample_col = "SampleID", A_col = "A", PARi_fine = PARifine,
                         specs = subset, dat_wide = dat_wide, par_names = par_names)

# Access the results array
result_array <- my_results$res
# Access the fitted curves
fitted_curves <- my_results$fitted_curves
# Access r2 and mse matrices
r2_matrix <- my_results$r2
mse_matrix <- my_results$mse

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Davis, R.E., C. M. Mason, E. W. Goolsby 2024 Comparative evolution of
photosynthetic light response curve: approaches and pitfalls in
phylogenetic modeling of a function-valued trait. IJPS, in review

Lobo, F. de A., M. P. de Barros, H. J. Dalmagro,  .C. Dalmolin,
W. E. Pereira, É.C. de Souza, G. L. Vourlitis and C. E. Rodriguez Ortiz
2013 Fitting net photosynthetic light-response curves with Microsoft
Excel – a critical look at the models. Photosynthetica 51 (3): 445-456.
}\if{html}{\out{</div>}}
}
