% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_vrs.R
\name{recode_vrs}
\alias{recode_vrs}
\title{Recode variables and their values based on a data dictionary}
\usage{
recode_vrs(data, data_dictionary, vrs = NULL, factor = FALSE)
}
\arguments{
\item{data}{A data frame with raw data.}

\item{data_dictionary}{A data dictionary containing labels for variables and their values.}

\item{vrs}{A character vector specifying variables of which the values need to be recoded.}

\item{factor}{A logical to indicate whether recoded variables need to be converted into ordered
factors.}
}
\value{
The input data frame with recoded and labelled variables.
}
\description{
Recode variables and their values based on a data dictionary
}
\examples{
\donttest{
if (FALSE) {
  library(phdcocktail)
  data(ibd_data1, package = "phdcocktail")
  ibd_data_recoded <- recode_vrs(
    data = ibd_data1, data_dictionary = ibd_data_dict,
    vrs = c("disease_location", "disease_behaviour", "gender"), factor = TRUE
  )
}
}

}
