% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_plot.r
\name{decision_plot}
\alias{decision_plot}
\title{Decision map plot}
\usage{
decision_plot(
  filename,
  filetype = c("png", "pdf", "svg"),
  xlab = "Toxicity Probability",
  ylab = "Efficacy Probability",
  x_breaks = c(0, 1),
  y_breaks = c(0, 1),
  x_labels = c(0, 1),
  y_labels = c(0, 1),
  zones = list(),
  legend_info = list(labels = NULL, colors = NULL),
  title = NULL,
  title_pos = c(0.05, 1.1),
  legend_pos = c(0.3, 1.2),
  grid_lines = TRUE,
  plot_size = c(7, 7)
)
}
\arguments{
\item{filename}{File path.}

\item{filetype}{File type.}

\item{xlab}{x-axis label. (Default is "Toxicity Probability")}

\item{ylab}{y-axis label. (Default is "Efficacy Probability")}

\item{x_breaks}{Numeric vector for x-axis major ticks. (Default is 'c(0, 1')}

\item{y_breaks}{Numeric vector for y-axis major ticks. (Default is 'c(0, 1')}

\item{x_labels}{Labels corresponding to \code{x_breaks}. (Default is 'c(0, 1')}

\item{y_labels}{Labels corresponding to \code{y_breaks}. (Default is 'c(0, 1')}

\item{zones}{A list of rectangular zones to draw, where each rectangle is a list with elements \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}, and \code{color}.}

\item{legend_info}{A list with two elements: \code{labels} (character vector) and \code{colors} (character vector) for the legend.}

\item{title}{Title of plot. (Default is 'NULL')}

\item{title_pos}{A numeric vector (x, y) indicating the position of the title text.}

\item{legend_pos}{A numeric vector (x, y) indicating the position of the legend.}

\item{grid_lines}{Whether to include background grid lines. (Default is TRUE.)}

\item{plot_size}{A numeric vector indicating width and height. (Default is c(7, 7)).}
}
\value{
No return value, called for side effects.
}
\description{
This function creates a decision plot containing customizable decision zones.
}
\examples{
zones <- list(list(xmin = 0.0, xmax = 0.2, ymin = 0, ymax = 1.0, color = "#a8eea8"),
              list(xmin = .2, xmax = .3, ymin = 0, ymax = 0.6, color = "#a8eea8"),
              list(xmin = .2, xmax = .3, ymin = .6, ymax = 1, color = "#a8d5ee"))
tmpfile <- tempfile(fileext = ".png")
decision_plot(tmpfile, filetype = "png", zones = zones, title = "Decision Zones")

}
