% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SA_step1.R
\name{SA_step1}
\alias{SA_step1}
\title{Sensitivity Analysis Function Step 1}
\usage{
SA_step1(lavoutput, mod_obs, mod_phant)
}
\arguments{
\item{lavoutput}{The lavaan output object output from lavaan functions sem() or lavaan() when fitting your observed model.}

\item{mod_obs}{A lavaan syntax for the observed model.}

\item{mod_phant}{A lavaan syntax for the phantom variable model.}
}
\value{
a list containing the names of all phantom covariance parameters.
}
\description{
\code{SA_step1()} is used to identify the phantom variables and generate names for their covariance parameters. The output of this function will be used in SA_step2().
}
\examples{
# covariance matrix
covmatrix <- matrix(c(
  0.25, 0.95, 0.43,
  0.95, 8.87, 2.66,
  0.43, 2.66, 10.86
), nrow = 3, byrow = TRUE)
colnames(covmatrix) <- c("X", "M2", "Y2")

# lavann syntax for observed model
observed <- " M2 ~ X
             Y2 ~ M2+X "

# lavaan output
obs_output <- lavaan::sem(model = observed, sample.cov = covmatrix, sample.nobs = 200)

# lavaan syntax for phantom variable model
phantom <- " M2 ~ M1 + Y1 + a*X
               Y2 ~ M1 + Y1 + b*M2 + cp*X "

Step1 <- SA_step1(
  lavoutput = obs_output,
  mod_obs = observed,
  mod_phant = phantom
)

}
