% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPCP_mat.R
\name{OPCP_mat}
\alias{OPCP_mat}
\title{Calculate Observed Proportion of Concordant Pairs (OPCP)}
\usage{
OPCP_mat(data, round_digits = 2)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{round_digits}{The number of decimals to be included in the resulting table.}
}
\value{
A matrix of correlations and OPCPs.
}
\description{
This function provides a matrix that contains Pearson correlations in the lower triangle and Observed Proportions of Concordant Pairs (OPCPs) in the upper triangle between multiple variables.
}
\examples{
# Example using the spi dataset from the psychTools package
sc <- psych::scoreVeryFast(psychTools::spi.keys, psychTools::spi)
spi_sc <- cbind(psychTools::spi, sc)
spi_sc_age_sex_B5 <- spi_sc |>
  dplyr::select(age, sex, Agree, Consc, Neuro, Extra, Open)


OPCP_mat(data = spi_sc_age_sex_B5)

}
