% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_explore.R
\name{pm_endemics}
\alias{pm_endemics}
\title{List endemic mammal species of Peru}
\usage{
pm_endemics(order = NULL, family = NULL, genus = NULL, ecoregion = NULL)
}
\arguments{
\item{order}{Optional character vector with one or more taxonomic orders
to keep. If \code{NULL} (default), no filter is applied by order.}

\item{family}{Optional character vector with one or more families to keep.
If \code{NULL} (default), no filter is applied by family.}

\item{genus}{Optional character vector with one or more genera to keep.
If \code{NULL} (default), no filter is applied by genus.}

\item{ecoregion}{Optional character vector with one or more ecoregion
codes (e.g. \code{"YUN"}, \code{"SB"}, \code{"COS"}). If supplied, only
species occurring in at least one of the given ecoregions are returned.}
}
\value{
A tibble with endemic species (subset of \code{peru_mammals}).
}
\description{
Returns endemic species from the Peruvian mammal backbone, with optional
filters by order, family and/or ecoregion.
}
\details{
This is a convenience wrapper around \code{\link{pm_species}()} with
\code{endemic = TRUE}.
}
\examples{

# All endemic species
pm_endemics()

# Endemic rodents
pm_endemics(order = "Rodentia")

# Endemic species in Yungas (YUN)
pm_endemics(ecoregion = "YUN")


}
