% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals-data.R
\docType{data}
\name{peru_mammals}
\alias{peru_mammals}
\title{Mammal species of Peru based on Pacheco et al. (2021)}
\format{
A tibble with 573 rows and 12 variables:
\describe{
\item{pm_id}{Character. Internal stable identifier for the species,
combining the original numeric id and an abbreviation of the genus.
Intended for internal linking between tables.}
\item{order}{Character. Taxonomic order (e.g. \emph{Didelphimorphia},
\emph{Rodentia}, \emph{Chiroptera}).}
\item{family}{Character. Taxonomic family.}
\item{genus}{Character. Genus name.}
\item{species}{Character. Specific epithet.}
\item{scientific_name}{Character. Binomial scientific name
(\emph{Genus species}), without authorship. This is the main field
used for name validation.}
\item{scientific_name_full}{Character. Full scientific name including
authorship and year, as provided in the original annex.}
\item{author}{Character. Authorship and year of the species name.}
\item{common_name}{Character. Common name in Spanish, when available.}
\item{endemic}{Logical. \code{TRUE} if the species is considered endemic
to Peru in Pacheco et al. (2021), \code{FALSE} otherwise.}
\item{ecoregions}{Character. Comma-separated codes of Peruvian
ecoregions where the species occurs, using the abbreviations
defined by Pacheco et al. (2021) (e.g. \code{"YUN, SB, SP"}). See
\code{\link{peru_mammals_ecoregions_meta}} for code definitions.}
\item{reference}{Character. Bibliographic notes or specific references
supporting the presence or taxonomy of the species.}
}
}
\source{
Pacheco, V., Cadenillas, R., Zeballos, H., Hurtado, C. M.,
Ruelas, D., & Pari, A. (2021). Lista actualizada de la diversidad de los
mamíferos del Perú y una propuesta para su actualización.
}
\usage{
data("peru_mammals")
}
\description{
A backbone of the terrestrial and marine mammal species known for Peru,
compiled from Pacheco et al. (2021) "Lista actualizada de la diversidad de
los mamíferos del Perú y una propuesta para su actualización".
}
\details{
Each row corresponds to a single species as listed in the original annex
of the paper. This dataset is the main taxonomic backbone used by the
\pkg{perumammals} package.
}
\keyword{datasets}
