% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadFile.R
\name{downloadFileButton}
\alias{downloadFileButton}
\title{downloadFileButton UI}
\usage{
downloadFileButton(id, downloadtypes = c("csv"), hovertext = NULL)
}
\arguments{
\item{id}{character id for the object}

\item{downloadtypes}{vector of values for data download types}

\item{hovertext}{tooltip hover text}
}
\description{
Creates a custom high-functionality button for file downloads with two
states - single download type or multiple-download types.  The button image
and pop-up menu (if needed) are set accordingly.  A tooltip can also be set
for the button.
}
\section{Button Features}{

\itemize{
    \item Consistent styling of the button, including a hover tooltip
    \item Single or multiple types of downloads
    \item Ability to download different data for each type of download
}
}

\section{Example}{

\code{downloadFileUI("mybuttonID1", c("csv", "tsv"), "Click Here")}
\code{downloadFileUI("mybuttonID2", "csv", "Click to download")}
}

\section{Shiny Usage}{

Call this function at the place in ui.R where the button should be placed.

It is paired with a call to \code{downloadFile(id, ...)}
in server.R
}

\examples{
# Inside ui_body.R or ui_sidebar.R

#single download type
downloadFileButton("object_id1", 
                   downloadtypes = c("csv"), 
                   hovertext = "Button 1 Tooltip")

#multiple download types
downloadFileButton("object_id2", 
                   downloadtypes = c("csv", "tsv"), 
                   hovertext = "Button 2 Tooltip")

}
\seealso{
\link[periscope]{downloadFile}

\link[periscope]{downloadFile_ValidateTypes}

\link[periscope]{downloadFile_AvailableTypes}
}
