#' Manager performance data
#'
#' Fictional data on the performance and other characteristics of a group of managers in a large company
#'
#' @format A dataframe with 571 rows and 13 variables:
#' \describe{
#' \item{employee_id}{The unique ID number for each manager}
#' \item{performance_group}{The performance group of each manager in a recent performance review: Bottom performer, Middle performer, Top performer}
#' \item{yrs_employed}{Total length of time employed by the company in years}
#' \item{manager_hire}{Whether or not the individual was hired directly to be a manager (Y) or promoted to manager (N)}
#' \item{test_score}{Score on a test given to all managers}
#' \item{group_size}{The number of employees in the group the manager is responsible for}
#' \item{concern_flag}{Whether or not the individual has been the subject of a complaint by a member of their group}
#' \item{mobile_flag}{Whether or not the individual works mobile (Y) or in the office (N)}
#' \item{customers}{The number of customer accounts the manager is responsible for}
#' \item{high_hours_flag}{Whether or not the manager has entered unusually high hours into their timesheet in the past year}
#' \item{transfers}{The number of transfer requests coming from the manager’s group while they have been a manager}
#' \item{reduced_schedule}{Whether the manager works part time (Y) or full time (N)}
#' \item{city}{The current office of the manager}
#' }
#' @examples
#' managers
"managers"
