% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi_for_age.R
\name{bmi_for_age}
\alias{bmi_for_age}
\alias{p_bmi_for_age}
\alias{q_bmi_for_age}
\alias{z_bmi_for_age}
\title{BMI for Age - Pediatric Growth Standard}
\usage{
p_bmi_for_age(q, male, age, source = getOption("pedbp_pgs_source", "CDC"), ...)

q_bmi_for_age(p, male, age, source = getOption("pedbp_pgs_source", "CDC"), ...)

z_bmi_for_age(q, male, age, source = getOption("pedbp_pgs_source", "CDC"), ...)
}
\arguments{
\item{q}{a vector of quantiles}

\item{male}{integer value, 1 = male, 0 = female}

\item{age}{numeric age, in months}

\item{source}{a character string denoting the data source providing the
parameters needed for the estimate.  Valid values are "CDC" and "WHO".  This
can be set explicitly, or by using the \code{pedbp_pgs_source} option.}

\item{...}{pass through}

\item{p}{a vector of probabilities}
}
\value{
\code{p_} method return values from the estimated distribution function.

\code{q_} methods return values from the estimated quantile function.

\code{z_} methods return standard scores.
}
\description{
BMI for age quantile, distribution, and zscore function based on LMS data
from the CDC and WHO.
}
\section{Notes}{
 CDC Recommends using WHO growth charts for infants and
children ages 0 to 2 years of age in the U.S. and CDC growth charts to
monitor growth for children age 2 years and older in the U.S.
}

\examples{
# The 54th quantile BMI (kg * m^(-2)) for a six year (72 month) old female
# is
bmi <- q_bmi_for_age(p = 0.54, male = 0, age = 72.0)
all.equal(p_bmi_for_age(q = bmi, male = 0, age = 72), 0.54)
all.equal(z_bmi_for_age(q = bmi, male = 0, age = 72), qnorm(0.54))

# Find the 29th percentile for females from ages 0 through 6 years in three
# month increments.  Sourcing the only CDC will generate a warning;
# suppressed in this example.
ages <- seq(0, 72, by = 1)
bmi_29 <-
  data.frame(
    age = ages
  , "CDC"     = suppressWarnings(q_bmi_for_age(p = 0.29, male = 0, age = ages, source = "CDC"))
  , "WHO"     = q_bmi_for_age(p = 0.29, male = 0, age = ages, source = "WHO")
  )

plot(
    x = bmi_29$age
  , y = bmi_29$WHO
  , col = 1
  , pch = 16
  , xlab = "Age (months)", ylab = "29th percentile BMI (kg * m^(-2))"
  , type = "b"
)
points(x = bmi_29$age, y = bmi_29$CDC, col = 2, pch = 17, type = "b")
legend("bottomright", col = 1:2, pch = 16:17, legend = c("WHO", "CDC"))

}
\references{
\url{https://www.cdc.gov/growthcharts/percentile_data_files.htm},
\url{https://www.who.int/tools/child-growth-standards/standards}
}
\seealso{
\itemize{
\item Distribution functions:
  \itemize{
    \item \code{\link{bmi_for_age}}
    \item \code{\link{head_circumference_for_age}}
    \item \code{\link{height_for_age}}
    \item \code{\link{length_for_age}}
    \item \code{\link{weight_for_age}}
    \item \code{\link{weight_for_length}}
    \item \code{\link{weight_for_height}}
  }
\item Plotting functions:
  \itemize{
    \item \code{\link{gs_chart}}
    \item \code{\link{gs_cdf}}
  }
\item Vignette:
  \itemize{
    \item \code{vignette(topic = "growth-standards", package = "pedbp")}
  }
}
}
