% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AB_permutation_test.R
\name{AB_permutation_test}
\alias{AB_permutation_test}
\title{AB_permutation_test}
\usage{
AB_permutation_test(
  x,
  y,
  test_statistic = "*",
  test_statistic_function = "mean",
  reps_max = 2000,
  no_duplicates = FALSE,
  show_plot = FALSE,
  show_plot_header = ""
)
}
\arguments{
\item{x}{factor vector to indicate conditions or phases (e.g., "A" and "B")}

\item{y}{numerical vector with the observed y-values}

\item{test_statistic}{character how to compute the test statistic c("A-B", "B-A", "*") *=two-sided}

\item{test_statistic_function}{character compute and compare "mean" or "median" for A and B}

\item{reps_max}{numerical maximum number of permutation replications (the theoretical number= n!)}

\item{no_duplicates}{boolean do a permutation test without duplicates (makes it much slower)}

\item{show_plot}{boolean show test plot of statistical test}

\item{show_plot_header}{character header of test plot}
}
\value{
List with the permutation test results:
  observed_test_statistic = computed test statistic,
  effect_size = computed effect size (similar to Cohen's d),
  random_assignments,
  p_randomization_AB = p value randomization AB test,
  one_sided_p = one-sided p-value in case of B-A or A-B.
}
\description{
Performs a regular permutations test for two conditions or phases (A and B).
}
\examples{
pdt::AB_permutation_test(
  as.factor(c(rep("A",20), rep("B",20))),
  c(rnorm(20), rnorm(20)+2),
  test_statistic="B-A",
  test_statistic_function="mean",
  reps_max=1000,
  no_duplicates=FALSE,
  show_plot=FALSE,
  show_plot_header="")

}
