% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictor_class.R
\name{new_predictor}
\alias{new_predictor}
\title{Create an object of class "predictor"}
\usage{
new_predictor(
  f = function() {
 },
  predictor_type = character(),
  lb,
  ub,
  support
)
}
\arguments{
\item{f}{a function that gives the probability mass/distribution function of
a random variable.}

\item{predictor_type}{a character describing the random variable. Either 
"discrete" or "continuous".}

\item{lb, ub}{if \code{predictor_type == "continuous"} double giving the
lower/upper bound of the pdf \code{f}.}

\item{support}{if \code{predictor_type == "discrete"} vector of the support 
of the pmf for \code{f}.}
}
\value{
an object of class \code{"predictor"}.
}
\description{
Create an object of class "predictor"
}
\examples{
new_predictor(
  f = function(x0) dnorm(x0, mean = 0, sd = 1),
  predictor_type = "continuous", lb = -Inf, ub = Inf
)
}
\seealso{
\code{\link{new_predictor_normal}},
  \code{\link{new_predictor_snp}} and \code{\link{new_predictor_binary}}.
}
