% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sing.R
\name{sing}
\alias{sing}
\title{Compute singular values of given matrix}
\usage{
sing(D)
}
\arguments{
\item{D}{The input data matrix (cannot have \code{NA} values).}
}
\value{
A numeric vector containing the singular values of \code{D}.
}
\description{
\code{sing()} calculates the singular values of a given data matrix \code{D}. This is
done with a call to \code{\link[=svd]{svd()}}, and is included in \code{pcpr} to enable the quick
characterization of a data matrix's raw low-rank structure, to help decide
whether \code{\link[=rrmc]{rrmc()}} or \code{\link[=root_pcp]{root_pcp()}} is the more appropriate PCP algorithm to
employ in conjunction with \code{D}.

Experimentally, the \code{\link[=rrmc]{rrmc()}} approach to PCP has best been able to handle
those datasets that are governed by complex underlying patterns characterized
by slowly decaying singular values, such as EH data. For observed data with a
well-defined low rank structure (rapidly decaying singular values),
\code{\link[=root_pcp]{root_pcp()}} may offer a better model estimate.
}
\examples{
data <- sim_data()
sing(data$D)
}
\references{
"Singular value decomposition" \href{https://en.wikipedia.org/wiki/Singular_value_decomposition}{Wikipedia article}.
}
\seealso{
\code{\link[=matrix_rank]{matrix_rank()}}
}
