% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcensmix.R
\name{pcensmixR}
\alias{pcensmixR}
\alias{pcensmixR.pcgen}
\title{Fitting a Normal Mixture Model to a Real Progressive Type-II Censored Mixture
Data Using EM Algorithm}
\usage{
pcensmixR(Pdat, ...)

\method{pcensmixR}{pcgen}(Pdat, start, iteration = 1e+05, INERiter = 20,
  warn = FALSE, ...)
}
\arguments{
\item{Pdat}{an object of class \code{"pcgen"} created by function
\code{\link[pcensmix]{pcgen}} or a two-column matrix (or data.frame)
with first column
giving a vector of censored version of a two-component mixed normal data,
and the other one indicating the censoring status associated with them (1
if not censored, otherwise zero).}

\item{...}{additinal arguments to pass by.}

\item{start}{a numeric vector; used as starting values for the EM algorithm.}

\item{iteration}{the maximum number of required iteration for the EM
algorithm until convergence-- default value is 1e+05.}

\item{INERiter}{the maximum number of required iteration for the second EM
algorithm-- default is 20.}

\item{warn}{logical. shows warning messages if \code{TRUE}, if there is any--
default is \code{FALSE}.}
}
\value{
\code{pcensmixR} gives an object of class \code{data.frame}
  containing the following components:
  \item{muhat1,sigmahat1}{component one parameter
  estimates (\eqn{\hat\mu_1}{\hat{\mu_1}}, \eqn{\hat\sigma_1}{\hat{\sigma_1}} )}
  \item{muhat2,sigmahat2}{component two parameter
  estimates (\eqn{\hat\mu_2}{\hat{\mu_2}}, \eqn{\hat\sigma_2}{\hat{\sigma_2}} )}
  \item{pihat}{estimation of mixture proportion \eqn{\hat\pi}{\hat{\pi}}}
  \item{se.muhat1,se.sigmahat1}{standard errors of
  \eqn{\hat\mu_1}{\hat{\mu_1}} and \eqn{\hat\sigma_1}{\hat{\sigma_1}}}
  \item{se.muhat2,se.sigmahat2}{standard errors of
  \eqn{\hat\mu_2}{\hat{\mu_2}} and \eqn{\hat\sigma_2}{\hat{\sigma_2}}}
  \item{se.pihat}{standard error of \eqn{\hat\pi}{\hat{\pi}}}
  \item{no.fails.comp1,no.fails.comp2}{number of failures from each mixture
  component} \item{no.cens.comp1,no.cens.comp2}{number of censored
  observations from each mixture component} \item{ll}{log-likelihood value}
}
\description{
{}

This function uses a two-layer EM algorithm to fit a mixture model to
progressive Type-II censored mixture data by estimating the latent mixture
components and the censored data.
}
\details{
This function fits a two-component normal mixture model to
  a given progressive Type-II censored data.

  It uses a two-layer EM algorithm for fitting the model. Generally speaking,
  the first layer estimates the mixture component latent variables, in the E-step, by finding their conditional expected
  values given the current parameter estimates and the data; and the second layer consists
  of another EM algorithm to estimate the missing censored data and eventually the parameters of interest.
  The layers are repeated until convergence achieved.
}
\note{
See \code{\link[pcensmix]{pcgen}} for the definition of censored
  version of data.
}
\examples{
## Example 1: fit a mixture model to 'insulate' data
set.seed(107)
Pdat<- pcgen(r = 15, p = 0.6, data = insulate)
pcensmixR(Pdat, start = c(5, 3, 35, 20, 0.6))

\dontrun{
## Example 2: fit a mixture model to 'Systolic blood pressure' data
set.seed(1010)
pcensmixR(Pdat = pcgen(360, 0.35, blood$Systolic.BP),
               start = c(120, 15, 150, 20, 0.6))}

}
\seealso{
\code{\link{pcgen}}, \code{\link[pcensmix]{pcensmixSim}}
}
\author{
Lida Fallah, John Hinde

Maintainer: Lida Fallah <l.fallah22@gmail.com>
}
