% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3tables_operations.R
\name{s3tables_list_tables}
\alias{s3tables_list_tables}
\title{List tables in the given table bucket}
\usage{
s3tables_list_tables(
  tableBucketARN,
  namespace = NULL,
  prefix = NULL,
  continuationToken = NULL,
  maxTables = NULL
)
}
\arguments{
\item{tableBucketARN}{[required] The Amazon resource Name (ARN) of the table bucket.}

\item{namespace}{The namespace of the tables.}

\item{prefix}{The prefix of the tables.}

\item{continuationToken}{\code{ContinuationToken} indicates to Amazon S3 that the list is being
continued on this bucket with a token. \code{ContinuationToken} is obfuscated
and is not a real key. You can use this \code{ContinuationToken} for
pagination of the list results.}

\item{maxTables}{The maximum number of tables to return.}
}
\description{
List tables in the given table bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html}{S3 Tables} in the \emph{Amazon Simple Storage Service User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3tables_list_tables/} for full documentation.
}
\keyword{internal}
