% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebs_operations.R
\name{ebs_list_changed_blocks}
\alias{ebs_list_changed_blocks}
\title{Returns information about the blocks that are different between two
Amazon Elastic Block Store snapshots of the same volume/snapshot lineage}
\usage{
ebs_list_changed_blocks(
  FirstSnapshotId = NULL,
  SecondSnapshotId,
  NextToken = NULL,
  MaxResults = NULL,
  StartingBlockIndex = NULL
)
}
\arguments{
\item{FirstSnapshotId}{The ID of the first snapshot to use for the comparison.

The \code{FirstSnapshotID} parameter must be specified with a
\code{SecondSnapshotId} parameter; otherwise, an error occurs.}

\item{SecondSnapshotId}{[required] The ID of the second snapshot to use for the comparison.

The \code{SecondSnapshotId} parameter must be specified with a
\code{FirstSnapshotID} parameter; otherwise, an error occurs.}

\item{NextToken}{The token to request the next page of results.

If you specify \strong{NextToken}, then \strong{StartingBlockIndex} is ignored.}

\item{MaxResults}{The maximum number of blocks to be returned by the request.

Even if additional blocks can be retrieved from the snapshot, the
request can return less blocks than \strong{MaxResults} or an empty array of
blocks.

To retrieve the next set of blocks from the snapshot, make another
request with the returned \strong{NextToken} value. The value of
\strong{NextToken} is \code{null} when there are no more blocks to return.}

\item{StartingBlockIndex}{The block index from which the comparison should start.

The list in the response will start from this block index or the next
valid block index in the snapshots.

If you specify \strong{NextToken}, then \strong{StartingBlockIndex} is ignored.}
}
\description{
Returns information about the blocks that are different between two Amazon Elastic Block Store snapshots of the same volume/snapshot lineage.

See \url{https://www.paws-r-sdk.com/docs/ebs_list_changed_blocks/} for full documentation.
}
\keyword{internal}
