# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchapplicationsignals_service.R
NULL

#' Use this operation to retrieve one or more service level objective (SLO)
#' budget reports
#'
#' @description
#' Use this operation to retrieve one or more *service level objective (SLO) budget reports*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_batch_get_service_level_objective_budget_report/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_batch_get_service_level_objective_budget_report/) for full documentation.
#'
#' @param Timestamp &#91;required&#93; The date and time that you want the report to be for. It is expressed as
#' the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
#' @param SloIds &#91;required&#93; An array containing the IDs of the service level objectives that you
#' want to include in the report.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_bat_get_ser_lev_obj_bud_rep
cloudwatchapplicationsignals_batch_get_service_level_objective_budget_report <- function(Timestamp, SloIds) {
  op <- new_operation(
    name = "BatchGetServiceLevelObjectiveBudgetReport",
    http_method = "POST",
    http_path = "/budget-report",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$batch_get_service_level_objective_budget_report_input(Timestamp = Timestamp, SloIds = SloIds)
  output <- .cloudwatchapplicationsignals$batch_get_service_level_objective_budget_report_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$batch_get_service_level_objective_budget_report <- cloudwatchapplicationsignals_batch_get_service_level_objective_budget_report

#' Creates a service level objective (SLO), which can help you ensure that
#' your critical business operations are meeting customer expectations
#'
#' @description
#' Creates a service level objective (SLO), which can help you ensure that your critical business operations are meeting customer expectations. Use SLOs to set and track specific target levels for the reliability and availability of your applications and services. SLOs use service level indicators (SLIs) to calculate whether the application is performing at the level that you want.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_create_service_level_objective/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_create_service_level_objective/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for this SLO.
#' @param Description An optional description for this SLO.
#' @param SliConfig If this SLO is a period-based SLO, this structure defines the
#' information about what performance metric this SLO will monitor.
#' 
#' You can't specify both `RequestBasedSliConfig` and `SliConfig` in the
#' same operation.
#' @param RequestBasedSliConfig If this SLO is a request-based SLO, this structure defines the
#' information about what performance metric this SLO will monitor.
#' 
#' You can't specify both `RequestBasedSliConfig` and `SliConfig` in the
#' same operation.
#' @param Goal This structure contains the attributes that determine the goal of the
#' SLO.
#' @param Tags A list of key-value pairs to associate with the SLO. You can associate
#' as many as 50 tags with an SLO. To be able to associate tags with the
#' SLO when you create the SLO, you must have the `cloudwatch:TagResource`
#' permission.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' @param BurnRateConfigurations Use this array to create *burn rates* for this SLO. Each burn rate is a
#' metric that indicates how fast the service is consuming the error
#' budget, relative to the attainment goal of the SLO.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_create_service_level_objective
cloudwatchapplicationsignals_create_service_level_objective <- function(Name, Description = NULL, SliConfig = NULL, RequestBasedSliConfig = NULL, Goal = NULL, Tags = NULL, BurnRateConfigurations = NULL) {
  op <- new_operation(
    name = "CreateServiceLevelObjective",
    http_method = "POST",
    http_path = "/slo",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$create_service_level_objective_input(Name = Name, Description = Description, SliConfig = SliConfig, RequestBasedSliConfig = RequestBasedSliConfig, Goal = Goal, Tags = Tags, BurnRateConfigurations = BurnRateConfigurations)
  output <- .cloudwatchapplicationsignals$create_service_level_objective_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$create_service_level_objective <- cloudwatchapplicationsignals_create_service_level_objective

#' Deletes the specified service level objective
#'
#' @description
#' Deletes the specified service level objective.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_delete_service_level_objective/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_delete_service_level_objective/) for full documentation.
#'
#' @param Id &#91;required&#93; The ARN or name of the service level objective to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_delete_service_level_objective
cloudwatchapplicationsignals_delete_service_level_objective <- function(Id) {
  op <- new_operation(
    name = "DeleteServiceLevelObjective",
    http_method = "DELETE",
    http_path = "/slo/{Id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$delete_service_level_objective_input(Id = Id)
  output <- .cloudwatchapplicationsignals$delete_service_level_objective_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$delete_service_level_objective <- cloudwatchapplicationsignals_delete_service_level_objective

#' Returns information about a service discovered by Application Signals
#'
#' @description
#' Returns information about a service discovered by Application Signals.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_get_service/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_get_service/) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time period to retrieve information about. When used in
#' a raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param EndTime &#91;required&#93; The end of the time period to retrieve information about. When used in a
#' raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param KeyAttributes &#91;required&#93; Use this field to specify which service you want to retrieve information
#' for. You must specify at least the `Type`, `Name`, and `Environment`
#' attributes.
#' 
#' This is a string-to-string map. It can include the following fields.
#' 
#' -   `Type` designates the type of object this is.
#' 
#' -   `ResourceType` specifies the type of the resource. This field is
#'     used only when the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Name` specifies the name of the object. This is used only if the
#'     value of the `Type` field is `Service`, `RemoteService`, or
#'     `AWS::Service`.
#' 
#' -   `Identifier` identifies the resource objects of this resource. This
#'     is used only if the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Environment` specifies the location where this object is hosted, or
#'     what it belongs to.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_get_service
cloudwatchapplicationsignals_get_service <- function(StartTime, EndTime, KeyAttributes) {
  op <- new_operation(
    name = "GetService",
    http_method = "POST",
    http_path = "/service",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$get_service_input(StartTime = StartTime, EndTime = EndTime, KeyAttributes = KeyAttributes)
  output <- .cloudwatchapplicationsignals$get_service_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$get_service <- cloudwatchapplicationsignals_get_service

#' Returns information about one SLO created in the account
#'
#' @description
#' Returns information about one SLO created in the account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_get_service_level_objective/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_get_service_level_objective/) for full documentation.
#'
#' @param Id &#91;required&#93; The ARN or name of the SLO that you want to retrieve information about.
#' You can find the ARNs of SLOs by using the
#' [`list_service_level_objectives`][cloudwatchapplicationsignals_list_service_level_objectives]
#' operation.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_get_service_level_objective
cloudwatchapplicationsignals_get_service_level_objective <- function(Id) {
  op <- new_operation(
    name = "GetServiceLevelObjective",
    http_method = "GET",
    http_path = "/slo/{Id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$get_service_level_objective_input(Id = Id)
  output <- .cloudwatchapplicationsignals$get_service_level_objective_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$get_service_level_objective <- cloudwatchapplicationsignals_get_service_level_objective

#' Returns a list of service dependencies of the service that you specify
#'
#' @description
#' Returns a list of service dependencies of the service that you specify. A dependency is an infrastructure component that an operation of this service connects with. Dependencies can include Amazon Web Services services, Amazon Web Services resources, and third-party services.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_dependencies/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_dependencies/) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time period to retrieve information about. When used in
#' a raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param EndTime &#91;required&#93; The end of the time period to retrieve information about. When used in a
#' raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested end time will be rounded to the nearest hour.
#' @param KeyAttributes &#91;required&#93; Use this field to specify which service you want to retrieve information
#' for. You must specify at least the `Type`, `Name`, and `Environment`
#' attributes.
#' 
#' This is a string-to-string map. It can include the following fields.
#' 
#' -   `Type` designates the type of object this is.
#' 
#' -   `ResourceType` specifies the type of the resource. This field is
#'     used only when the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Name` specifies the name of the object. This is used only if the
#'     value of the `Type` field is `Service`, `RemoteService`, or
#'     `AWS::Service`.
#' 
#' -   `Identifier` identifies the resource objects of this resource. This
#'     is used only if the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Environment` specifies the location where this object is hosted, or
#'     what it belongs to.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default of 50 is used.
#' @param NextToken Include this value, if it was returned by the previous operation, to get
#' the next set of service dependencies.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_list_service_dependencies
cloudwatchapplicationsignals_list_service_dependencies <- function(StartTime, EndTime, KeyAttributes, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListServiceDependencies",
    http_method = "POST",
    http_path = "/service-dependencies",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ServiceDependencies"),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$list_service_dependencies_input(StartTime = StartTime, EndTime = EndTime, KeyAttributes = KeyAttributes, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchapplicationsignals$list_service_dependencies_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$list_service_dependencies <- cloudwatchapplicationsignals_list_service_dependencies

#' Returns the list of dependents that invoked the specified service during
#' the provided time range
#'
#' @description
#' Returns the list of dependents that invoked the specified service during the provided time range. Dependents include other services, CloudWatch Synthetics canaries, and clients that are instrumented with CloudWatch RUM app monitors.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_dependents/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_dependents/) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time period to retrieve information about. When used in
#' a raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param EndTime &#91;required&#93; The end of the time period to retrieve information about. When used in a
#' raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param KeyAttributes &#91;required&#93; Use this field to specify which service you want to retrieve information
#' for. You must specify at least the `Type`, `Name`, and `Environment`
#' attributes.
#' 
#' This is a string-to-string map. It can include the following fields.
#' 
#' -   `Type` designates the type of object this is.
#' 
#' -   `ResourceType` specifies the type of the resource. This field is
#'     used only when the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Name` specifies the name of the object. This is used only if the
#'     value of the `Type` field is `Service`, `RemoteService`, or
#'     `AWS::Service`.
#' 
#' -   `Identifier` identifies the resource objects of this resource. This
#'     is used only if the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Environment` specifies the location where this object is hosted, or
#'     what it belongs to.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default of 50 is used.
#' @param NextToken Include this value, if it was returned by the previous operation, to get
#' the next set of service dependents.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_list_service_dependents
cloudwatchapplicationsignals_list_service_dependents <- function(StartTime, EndTime, KeyAttributes, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListServiceDependents",
    http_method = "POST",
    http_path = "/service-dependents",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ServiceDependents"),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$list_service_dependents_input(StartTime = StartTime, EndTime = EndTime, KeyAttributes = KeyAttributes, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchapplicationsignals$list_service_dependents_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$list_service_dependents <- cloudwatchapplicationsignals_list_service_dependents

#' Returns a list of SLOs created in this account
#'
#' @description
#' Returns a list of SLOs created in this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_level_objectives/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_level_objectives/) for full documentation.
#'
#' @param KeyAttributes You can use this optional field to specify which services you want to
#' retrieve SLO information for.
#' 
#' This is a string-to-string map. It can include the following fields.
#' 
#' -   `Type` designates the type of object this is.
#' 
#' -   `ResourceType` specifies the type of the resource. This field is
#'     used only when the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Name` specifies the name of the object. This is used only if the
#'     value of the `Type` field is `Service`, `RemoteService`, or
#'     `AWS::Service`.
#' 
#' -   `Identifier` identifies the resource objects of this resource. This
#'     is used only if the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Environment` specifies the location where this object is hosted, or
#'     what it belongs to.
#' @param OperationName The name of the operation that this SLO is associated with.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default of 50 is used.
#' @param NextToken Include this value, if it was returned by the previous operation, to get
#' the next set of service level objectives.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_list_service_level_objectives
cloudwatchapplicationsignals_list_service_level_objectives <- function(KeyAttributes = NULL, OperationName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListServiceLevelObjectives",
    http_method = "POST",
    http_path = "/slos",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SloSummaries"),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$list_service_level_objectives_input(KeyAttributes = KeyAttributes, OperationName = OperationName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchapplicationsignals$list_service_level_objectives_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$list_service_level_objectives <- cloudwatchapplicationsignals_list_service_level_objectives

#' Returns a list of the operations of this service that have been
#' discovered by Application Signals
#'
#' @description
#' Returns a list of the *operations* of this service that have been discovered by Application Signals. Only the operations that were invoked during the specified time range are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_operations/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_service_operations/) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time period to retrieve information about. When used in
#' a raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param EndTime &#91;required&#93; The end of the time period to retrieve information about. When used in a
#' raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested end time will be rounded to the nearest hour.
#' @param KeyAttributes &#91;required&#93; Use this field to specify which service you want to retrieve information
#' for. You must specify at least the `Type`, `Name`, and `Environment`
#' attributes.
#' 
#' This is a string-to-string map. It can include the following fields.
#' 
#' -   `Type` designates the type of object this is.
#' 
#' -   `ResourceType` specifies the type of the resource. This field is
#'     used only when the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Name` specifies the name of the object. This is used only if the
#'     value of the `Type` field is `Service`, `RemoteService`, or
#'     `AWS::Service`.
#' 
#' -   `Identifier` identifies the resource objects of this resource. This
#'     is used only if the value of the `Type` field is `Resource` or
#'     `AWS::Resource`.
#' 
#' -   `Environment` specifies the location where this object is hosted, or
#'     what it belongs to.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default of 50 is used.
#' @param NextToken Include this value, if it was returned by the previous operation, to get
#' the next set of service operations.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_list_service_operations
cloudwatchapplicationsignals_list_service_operations <- function(StartTime, EndTime, KeyAttributes, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListServiceOperations",
    http_method = "POST",
    http_path = "/service-operations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ServiceOperations"),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$list_service_operations_input(StartTime = StartTime, EndTime = EndTime, KeyAttributes = KeyAttributes, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchapplicationsignals$list_service_operations_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$list_service_operations <- cloudwatchapplicationsignals_list_service_operations

#' Returns a list of services that have been discovered by Application
#' Signals
#'
#' @description
#' Returns a list of services that have been discovered by Application Signals. A service represents a minimum logical and transactional unit that completes a business function. Services are discovered through Application Signals instrumentation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_services/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_services/) for full documentation.
#'
#' @param StartTime &#91;required&#93; The start of the time period to retrieve information about. When used in
#' a raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param EndTime &#91;required&#93; The end of the time period to retrieve information about. When used in a
#' raw HTTP Query API, it is formatted as be epoch time in seconds. For
#' example: `1698778057`
#' 
#' Your requested start time will be rounded to the nearest hour.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default of 50 is used.
#' @param NextToken Include this value, if it was returned by the previous operation, to get
#' the next set of services.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_list_services
cloudwatchapplicationsignals_list_services <- function(StartTime, EndTime, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "GET",
    http_path = "/services",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ServiceSummaries"),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$list_services_input(StartTime = StartTime, EndTime = EndTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchapplicationsignals$list_services_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$list_services <- cloudwatchapplicationsignals_list_services

#' Displays the tags associated with a CloudWatch resource
#'
#' @description
#' Displays the tags associated with a CloudWatch resource. Tags can be assigned to service level objectives.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudWatch resource that you want
#' to view tags for.
#' 
#' The ARN format of an Application Signals SLO is
#' `arn:aws:cloudwatch:Region:account-id:slo:slo-name `
#' 
#' For more information about ARN format, see [Resource Types Defined by
#' Amazon
#' CloudWatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_list_tags_for_resource
cloudwatchapplicationsignals_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cloudwatchapplicationsignals$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$list_tags_for_resource <- cloudwatchapplicationsignals_list_tags_for_resource

#' Enables this Amazon Web Services account to be able to use CloudWatch
#' Application Signals by creating the
#' AWSServiceRoleForCloudWatchApplicationSignals service-linked role
#'
#' @description
#' Enables this Amazon Web Services account to be able to use CloudWatch Application Signals by creating the *AWSServiceRoleForCloudWatchApplicationSignals* service-linked role. This service- linked role has the following permissions:
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_start_discovery/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_start_discovery/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_start_discovery
cloudwatchapplicationsignals_start_discovery <- function() {
  op <- new_operation(
    name = "StartDiscovery",
    http_method = "POST",
    http_path = "/start-discovery",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$start_discovery_input()
  output <- .cloudwatchapplicationsignals$start_discovery_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$start_discovery <- cloudwatchapplicationsignals_start_discovery

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' resource, such as a service level objective
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch resource, such as a service level objective.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudWatch resource that you want
#' to set tags for.
#' 
#' The ARN format of an Application Signals SLO is
#' `arn:aws:cloudwatch:Region:account-id:slo:slo-name `
#' 
#' For more information about ARN format, see [Resource Types Defined by
#' Amazon
#' CloudWatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
#' in the *Amazon Web Services General Reference*.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the alarm.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_tag_resource
cloudwatchapplicationsignals_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tag-resource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cloudwatchapplicationsignals$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$tag_resource <- cloudwatchapplicationsignals_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudWatch resource that you want
#' to delete tags from.
#' 
#' The ARN format of an Application Signals SLO is
#' `arn:aws:cloudwatch:Region:account-id:slo:slo-name `
#' 
#' For more information about ARN format, see [Resource Types Defined by
#' Amazon
#' CloudWatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
#' in the *Amazon Web Services General Reference*.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_untag_resource
cloudwatchapplicationsignals_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untag-resource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cloudwatchapplicationsignals$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$untag_resource <- cloudwatchapplicationsignals_untag_resource

#' Updates an existing service level objective (SLO)
#'
#' @description
#' Updates an existing service level objective (SLO). If you omit parameters, the previous values of those parameters are retained.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_update_service_level_objective/](https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_update_service_level_objective/) for full documentation.
#'
#' @param Id &#91;required&#93; The Amazon Resource Name (ARN) or name of the service level objective
#' that you want to update.
#' @param Description An optional description for the SLO.
#' @param SliConfig If this SLO is a period-based SLO, this structure defines the
#' information about what performance metric this SLO will monitor.
#' @param RequestBasedSliConfig If this SLO is a request-based SLO, this structure defines the
#' information about what performance metric this SLO will monitor.
#' 
#' You can't specify both `SliConfig` and `RequestBasedSliConfig` in the
#' same operation.
#' @param Goal A structure that contains the attributes that determine the goal of the
#' SLO. This includes the time period for evaluation and the attainment
#' threshold.
#' @param BurnRateConfigurations Use this array to create *burn rates* for this SLO. Each burn rate is a
#' metric that indicates how fast the service is consuming the error
#' budget, relative to the attainment goal of the SLO.
#'
#' @keywords internal
#'
#' @rdname cloudwatchapplicationsignals_update_service_level_objective
cloudwatchapplicationsignals_update_service_level_objective <- function(Id, Description = NULL, SliConfig = NULL, RequestBasedSliConfig = NULL, Goal = NULL, BurnRateConfigurations = NULL) {
  op <- new_operation(
    name = "UpdateServiceLevelObjective",
    http_method = "PATCH",
    http_path = "/slo/{Id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchapplicationsignals$update_service_level_objective_input(Id = Id, Description = Description, SliConfig = SliConfig, RequestBasedSliConfig = RequestBasedSliConfig, Goal = Goal, BurnRateConfigurations = BurnRateConfigurations)
  output <- .cloudwatchapplicationsignals$update_service_level_objective_output()
  config <- get_config()
  svc <- .cloudwatchapplicationsignals$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchapplicationsignals$operations$update_service_level_objective <- cloudwatchapplicationsignals_update_service_level_objective
