% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devopsguru_operations.R
\name{devopsguru_describe_organization_resource_collection_health}
\alias{devopsguru_describe_organization_resource_collection_health}
\title{Provides an overview of your system's health}
\usage{
devopsguru_describe_organization_resource_collection_health(
  OrganizationResourceCollectionType,
  AccountIds = NULL,
  OrganizationalUnitIds = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{OrganizationResourceCollectionType}{[required] An Amazon Web Services resource collection type. This type specifies how
analyzed Amazon Web Services resources are defined. The two types of
Amazon Web Services resource collections supported are Amazon Web
Services CloudFormation stacks and Amazon Web Services resources that
contain the same Amazon Web Services tag. DevOps Guru can be configured
to analyze the Amazon Web Services resources that are defined in the
stacks or that are tagged using the same tag \emph{key}. You can specify up
to 500 Amazon Web Services CloudFormation stacks.}

\item{AccountIds}{The ID of the Amazon Web Services account.}

\item{OrganizationalUnitIds}{The ID of the organizational unit.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Provides an overview of your system's health. If additional member accounts are part of your organization, you can filter those accounts using the \code{AccountIds} field.

See \url{https://www.paws-r-sdk.com/docs/devopsguru_describe_organization_resource_collection_health/} for full documentation.
}
\keyword{internal}
