# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include fis_service.R
NULL

#' Creates an experiment template
#'
#' @description
#' Creates an experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_create_experiment_template/](https://www.paws-r-sdk.com/docs/fis_create_experiment_template/) for full documentation.
#'
#' @param clientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param description &#91;required&#93; A description for the experiment template.
#' @param stopConditions &#91;required&#93; The stop conditions.
#' @param targets The targets for the experiment.
#' @param actions &#91;required&#93; The actions for the experiment.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that grants the FIS
#' service permission to perform service actions on your behalf.
#' @param tags The tags to apply to the experiment template.
#' @param logConfiguration The configuration for experiment logging.
#' @param experimentOptions The experiment options for the experiment template.
#' @param experimentReportConfiguration The experiment report configuration for the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_create_experiment_template
fis_create_experiment_template <- function(clientToken, description, stopConditions, targets = NULL, actions, roleArn, tags = NULL, logConfiguration = NULL, experimentOptions = NULL, experimentReportConfiguration = NULL) {
  op <- new_operation(
    name = "CreateExperimentTemplate",
    http_method = "POST",
    http_path = "/experimentTemplates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$create_experiment_template_input(clientToken = clientToken, description = description, stopConditions = stopConditions, targets = targets, actions = actions, roleArn = roleArn, tags = tags, logConfiguration = logConfiguration, experimentOptions = experimentOptions, experimentReportConfiguration = experimentReportConfiguration)
  output <- .fis$create_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$create_experiment_template <- fis_create_experiment_template

#' Creates a target account configuration for the experiment template
#'
#' @description
#' Creates a target account configuration for the experiment template. A target account configuration is required when `accountTargeting` of `experimentOptions` is set to `multi-account`. For more information, see [experiment options](https://docs.aws.amazon.com/fis/latest/userguide/experiment-options.html) in the *Fault Injection Service User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_create_target_account_configuration/](https://www.paws-r-sdk.com/docs/fis_create_target_account_configuration/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param experimentTemplateId &#91;required&#93; The experiment template ID.
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the target account.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role for the target account.
#' @param description The description of the target account.
#'
#' @keywords internal
#'
#' @rdname fis_create_target_account_configuration
fis_create_target_account_configuration <- function(clientToken = NULL, experimentTemplateId, accountId, roleArn, description = NULL) {
  op <- new_operation(
    name = "CreateTargetAccountConfiguration",
    http_method = "POST",
    http_path = "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$create_target_account_configuration_input(clientToken = clientToken, experimentTemplateId = experimentTemplateId, accountId = accountId, roleArn = roleArn, description = description)
  output <- .fis$create_target_account_configuration_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$create_target_account_configuration <- fis_create_target_account_configuration

#' Deletes the specified experiment template
#'
#' @description
#' Deletes the specified experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_delete_experiment_template/](https://www.paws-r-sdk.com/docs/fis_delete_experiment_template/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_delete_experiment_template
fis_delete_experiment_template <- function(id) {
  op <- new_operation(
    name = "DeleteExperimentTemplate",
    http_method = "DELETE",
    http_path = "/experimentTemplates/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$delete_experiment_template_input(id = id)
  output <- .fis$delete_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$delete_experiment_template <- fis_delete_experiment_template

#' Deletes the specified target account configuration of the experiment
#' template
#'
#' @description
#' Deletes the specified target account configuration of the experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_delete_target_account_configuration/](https://www.paws-r-sdk.com/docs/fis_delete_target_account_configuration/) for full documentation.
#'
#' @param experimentTemplateId &#91;required&#93; The ID of the experiment template.
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the target account.
#'
#' @keywords internal
#'
#' @rdname fis_delete_target_account_configuration
fis_delete_target_account_configuration <- function(experimentTemplateId, accountId) {
  op <- new_operation(
    name = "DeleteTargetAccountConfiguration",
    http_method = "DELETE",
    http_path = "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$delete_target_account_configuration_input(experimentTemplateId = experimentTemplateId, accountId = accountId)
  output <- .fis$delete_target_account_configuration_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$delete_target_account_configuration <- fis_delete_target_account_configuration

#' Gets information about the specified FIS action
#'
#' @description
#' Gets information about the specified FIS action.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_action/](https://www.paws-r-sdk.com/docs/fis_get_action/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the action.
#'
#' @keywords internal
#'
#' @rdname fis_get_action
fis_get_action <- function(id) {
  op <- new_operation(
    name = "GetAction",
    http_method = "GET",
    http_path = "/actions/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_action_input(id = id)
  output <- .fis$get_action_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_action <- fis_get_action

#' Gets information about the specified experiment
#'
#' @description
#' Gets information about the specified experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_experiment/](https://www.paws-r-sdk.com/docs/fis_get_experiment/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment.
#'
#' @keywords internal
#'
#' @rdname fis_get_experiment
fis_get_experiment <- function(id) {
  op <- new_operation(
    name = "GetExperiment",
    http_method = "GET",
    http_path = "/experiments/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_experiment_input(id = id)
  output <- .fis$get_experiment_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_experiment <- fis_get_experiment

#' Gets information about the specified target account configuration of the
#' experiment
#'
#' @description
#' Gets information about the specified target account configuration of the experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_experiment_target_account_configuration/](https://www.paws-r-sdk.com/docs/fis_get_experiment_target_account_configuration/) for full documentation.
#'
#' @param experimentId &#91;required&#93; The ID of the experiment.
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the target account.
#'
#' @keywords internal
#'
#' @rdname fis_get_experiment_target_account_configuration
fis_get_experiment_target_account_configuration <- function(experimentId, accountId) {
  op <- new_operation(
    name = "GetExperimentTargetAccountConfiguration",
    http_method = "GET",
    http_path = "/experiments/{id}/targetAccountConfigurations/{accountId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_experiment_target_account_configuration_input(experimentId = experimentId, accountId = accountId)
  output <- .fis$get_experiment_target_account_configuration_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_experiment_target_account_configuration <- fis_get_experiment_target_account_configuration

#' Gets information about the specified experiment template
#'
#' @description
#' Gets information about the specified experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_experiment_template/](https://www.paws-r-sdk.com/docs/fis_get_experiment_template/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_get_experiment_template
fis_get_experiment_template <- function(id) {
  op <- new_operation(
    name = "GetExperimentTemplate",
    http_method = "GET",
    http_path = "/experimentTemplates/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_experiment_template_input(id = id)
  output <- .fis$get_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_experiment_template <- fis_get_experiment_template

#' Gets information about the specified safety lever
#'
#' @description
#' Gets information about the specified safety lever.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_safety_lever/](https://www.paws-r-sdk.com/docs/fis_get_safety_lever/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the safety lever.
#'
#' @keywords internal
#'
#' @rdname fis_get_safety_lever
fis_get_safety_lever <- function(id) {
  op <- new_operation(
    name = "GetSafetyLever",
    http_method = "GET",
    http_path = "/safetyLevers/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_safety_lever_input(id = id)
  output <- .fis$get_safety_lever_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_safety_lever <- fis_get_safety_lever

#' Gets information about the specified target account configuration of the
#' experiment template
#'
#' @description
#' Gets information about the specified target account configuration of the experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_target_account_configuration/](https://www.paws-r-sdk.com/docs/fis_get_target_account_configuration/) for full documentation.
#'
#' @param experimentTemplateId &#91;required&#93; The ID of the experiment template.
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the target account.
#'
#' @keywords internal
#'
#' @rdname fis_get_target_account_configuration
fis_get_target_account_configuration <- function(experimentTemplateId, accountId) {
  op <- new_operation(
    name = "GetTargetAccountConfiguration",
    http_method = "GET",
    http_path = "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_target_account_configuration_input(experimentTemplateId = experimentTemplateId, accountId = accountId)
  output <- .fis$get_target_account_configuration_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_target_account_configuration <- fis_get_target_account_configuration

#' Gets information about the specified resource type
#'
#' @description
#' Gets information about the specified resource type.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_get_target_resource_type/](https://www.paws-r-sdk.com/docs/fis_get_target_resource_type/) for full documentation.
#'
#' @param resourceType &#91;required&#93; The resource type.
#'
#' @keywords internal
#'
#' @rdname fis_get_target_resource_type
fis_get_target_resource_type <- function(resourceType) {
  op <- new_operation(
    name = "GetTargetResourceType",
    http_method = "GET",
    http_path = "/targetResourceTypes/{resourceType}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$get_target_resource_type_input(resourceType = resourceType)
  output <- .fis$get_target_resource_type_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_target_resource_type <- fis_get_target_resource_type

#' Lists the available FIS actions
#'
#' @description
#' Lists the available FIS actions.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_actions/](https://www.paws-r-sdk.com/docs/fis_list_actions/) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_actions
fis_list_actions <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListActions",
    http_method = "GET",
    http_path = "/actions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "actions"),
    stream_api = FALSE
  )
  input <- .fis$list_actions_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_actions_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_actions <- fis_list_actions

#' Lists the resolved targets information of the specified experiment
#'
#' @description
#' Lists the resolved targets information of the specified experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_experiment_resolved_targets/](https://www.paws-r-sdk.com/docs/fis_list_experiment_resolved_targets/) for full documentation.
#'
#' @param experimentId &#91;required&#93; The ID of the experiment.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#' @param nextToken The token for the next page of results.
#' @param targetName The name of the target.
#'
#' @keywords internal
#'
#' @rdname fis_list_experiment_resolved_targets
fis_list_experiment_resolved_targets <- function(experimentId, maxResults = NULL, nextToken = NULL, targetName = NULL) {
  op <- new_operation(
    name = "ListExperimentResolvedTargets",
    http_method = "GET",
    http_path = "/experiments/{id}/resolvedTargets",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "resolvedTargets"),
    stream_api = FALSE
  )
  input <- .fis$list_experiment_resolved_targets_input(experimentId = experimentId, maxResults = maxResults, nextToken = nextToken, targetName = targetName)
  output <- .fis$list_experiment_resolved_targets_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_experiment_resolved_targets <- fis_list_experiment_resolved_targets

#' Lists the target account configurations of the specified experiment
#'
#' @description
#' Lists the target account configurations of the specified experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_experiment_target_account_configurations/](https://www.paws-r-sdk.com/docs/fis_list_experiment_target_account_configurations/) for full documentation.
#'
#' @param experimentId &#91;required&#93; The ID of the experiment.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_experiment_target_account_configurations
fis_list_experiment_target_account_configurations <- function(experimentId, nextToken = NULL) {
  op <- new_operation(
    name = "ListExperimentTargetAccountConfigurations",
    http_method = "GET",
    http_path = "/experiments/{id}/targetAccountConfigurations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$list_experiment_target_account_configurations_input(experimentId = experimentId, nextToken = nextToken)
  output <- .fis$list_experiment_target_account_configurations_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_experiment_target_account_configurations <- fis_list_experiment_target_account_configurations

#' Lists your experiment templates
#'
#' @description
#' Lists your experiment templates.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_experiment_templates/](https://www.paws-r-sdk.com/docs/fis_list_experiment_templates/) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_experiment_templates
fis_list_experiment_templates <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListExperimentTemplates",
    http_method = "GET",
    http_path = "/experimentTemplates",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "experimentTemplates"),
    stream_api = FALSE
  )
  input <- .fis$list_experiment_templates_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_experiment_templates_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_experiment_templates <- fis_list_experiment_templates

#' Lists your experiments
#'
#' @description
#' Lists your experiments.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_experiments/](https://www.paws-r-sdk.com/docs/fis_list_experiments/) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#' @param experimentTemplateId The ID of the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_list_experiments
fis_list_experiments <- function(maxResults = NULL, nextToken = NULL, experimentTemplateId = NULL) {
  op <- new_operation(
    name = "ListExperiments",
    http_method = "GET",
    http_path = "/experiments",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "experiments"),
    stream_api = FALSE
  )
  input <- .fis$list_experiments_input(maxResults = maxResults, nextToken = nextToken, experimentTemplateId = experimentTemplateId)
  output <- .fis$list_experiments_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_experiments <- fis_list_experiments

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/fis_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname fis_list_tags_for_resource
fis_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .fis$list_tags_for_resource_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_tags_for_resource <- fis_list_tags_for_resource

#' Lists the target account configurations of the specified experiment
#' template
#'
#' @description
#' Lists the target account configurations of the specified experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_target_account_configurations/](https://www.paws-r-sdk.com/docs/fis_list_target_account_configurations/) for full documentation.
#'
#' @param experimentTemplateId &#91;required&#93; The ID of the experiment template.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_target_account_configurations
fis_list_target_account_configurations <- function(experimentTemplateId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTargetAccountConfigurations",
    http_method = "GET",
    http_path = "/experimentTemplates/{id}/targetAccountConfigurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "targetAccountConfigurations"),
    stream_api = FALSE
  )
  input <- .fis$list_target_account_configurations_input(experimentTemplateId = experimentTemplateId, maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_target_account_configurations_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_target_account_configurations <- fis_list_target_account_configurations

#' Lists the target resource types
#'
#' @description
#' Lists the target resource types.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_list_target_resource_types/](https://www.paws-r-sdk.com/docs/fis_list_target_resource_types/) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_target_resource_types
fis_list_target_resource_types <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTargetResourceTypes",
    http_method = "GET",
    http_path = "/targetResourceTypes",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "targetResourceTypes"),
    stream_api = FALSE
  )
  input <- .fis$list_target_resource_types_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_target_resource_types_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_target_resource_types <- fis_list_target_resource_types

#' Starts running an experiment from the specified experiment template
#'
#' @description
#' Starts running an experiment from the specified experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_start_experiment/](https://www.paws-r-sdk.com/docs/fis_start_experiment/) for full documentation.
#'
#' @param clientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param experimentTemplateId &#91;required&#93; The ID of the experiment template.
#' @param experimentOptions The experiment options for running the experiment.
#' @param tags The tags to apply to the experiment.
#'
#' @keywords internal
#'
#' @rdname fis_start_experiment
fis_start_experiment <- function(clientToken, experimentTemplateId, experimentOptions = NULL, tags = NULL) {
  op <- new_operation(
    name = "StartExperiment",
    http_method = "POST",
    http_path = "/experiments",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$start_experiment_input(clientToken = clientToken, experimentTemplateId = experimentTemplateId, experimentOptions = experimentOptions, tags = tags)
  output <- .fis$start_experiment_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$start_experiment <- fis_start_experiment

#' Stops the specified experiment
#'
#' @description
#' Stops the specified experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_stop_experiment/](https://www.paws-r-sdk.com/docs/fis_stop_experiment/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment.
#'
#' @keywords internal
#'
#' @rdname fis_stop_experiment
fis_stop_experiment <- function(id) {
  op <- new_operation(
    name = "StopExperiment",
    http_method = "DELETE",
    http_path = "/experiments/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$stop_experiment_input(id = id)
  output <- .fis$stop_experiment_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$stop_experiment <- fis_stop_experiment

#' Applies the specified tags to the specified resource
#'
#' @description
#' Applies the specified tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_tag_resource/](https://www.paws-r-sdk.com/docs/fis_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags for the resource.
#'
#' @keywords internal
#'
#' @rdname fis_tag_resource
fis_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .fis$tag_resource_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$tag_resource <- fis_tag_resource

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_untag_resource/](https://www.paws-r-sdk.com/docs/fis_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys The tag keys to remove.
#'
#' @keywords internal
#'
#' @rdname fis_untag_resource
fis_untag_resource <- function(resourceArn, tagKeys = NULL) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .fis$untag_resource_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$untag_resource <- fis_untag_resource

#' Updates the specified experiment template
#'
#' @description
#' Updates the specified experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_update_experiment_template/](https://www.paws-r-sdk.com/docs/fis_update_experiment_template/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment template.
#' @param description A description for the template.
#' @param stopConditions The stop conditions for the experiment.
#' @param targets The targets for the experiment.
#' @param actions The actions for the experiment.
#' @param roleArn The Amazon Resource Name (ARN) of an IAM role that grants the FIS
#' service permission to perform service actions on your behalf.
#' @param logConfiguration The configuration for experiment logging.
#' @param experimentOptions The experiment options for the experiment template.
#' @param experimentReportConfiguration The experiment report configuration for the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_update_experiment_template
fis_update_experiment_template <- function(id, description = NULL, stopConditions = NULL, targets = NULL, actions = NULL, roleArn = NULL, logConfiguration = NULL, experimentOptions = NULL, experimentReportConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateExperimentTemplate",
    http_method = "PATCH",
    http_path = "/experimentTemplates/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$update_experiment_template_input(id = id, description = description, stopConditions = stopConditions, targets = targets, actions = actions, roleArn = roleArn, logConfiguration = logConfiguration, experimentOptions = experimentOptions, experimentReportConfiguration = experimentReportConfiguration)
  output <- .fis$update_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$update_experiment_template <- fis_update_experiment_template

#' Updates the specified safety lever state
#'
#' @description
#' Updates the specified safety lever state.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_update_safety_lever_state/](https://www.paws-r-sdk.com/docs/fis_update_safety_lever_state/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the safety lever.
#' @param state &#91;required&#93; The state of the safety lever.
#'
#' @keywords internal
#'
#' @rdname fis_update_safety_lever_state
fis_update_safety_lever_state <- function(id, state) {
  op <- new_operation(
    name = "UpdateSafetyLeverState",
    http_method = "PATCH",
    http_path = "/safetyLevers/{id}/state",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$update_safety_lever_state_input(id = id, state = state)
  output <- .fis$update_safety_lever_state_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$update_safety_lever_state <- fis_update_safety_lever_state

#' Updates the target account configuration for the specified experiment
#' template
#'
#' @description
#' Updates the target account configuration for the specified experiment template.
#'
#' See [https://www.paws-r-sdk.com/docs/fis_update_target_account_configuration/](https://www.paws-r-sdk.com/docs/fis_update_target_account_configuration/) for full documentation.
#'
#' @param experimentTemplateId &#91;required&#93; The ID of the experiment template.
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the target account.
#' @param roleArn The Amazon Resource Name (ARN) of an IAM role for the target account.
#' @param description The description of the target account.
#'
#' @keywords internal
#'
#' @rdname fis_update_target_account_configuration
fis_update_target_account_configuration <- function(experimentTemplateId, accountId, roleArn = NULL, description = NULL) {
  op <- new_operation(
    name = "UpdateTargetAccountConfiguration",
    http_method = "PATCH",
    http_path = "/experimentTemplates/{id}/targetAccountConfigurations/{accountId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .fis$update_target_account_configuration_input(experimentTemplateId = experimentTemplateId, accountId = accountId, roleArn = roleArn, description = description)
  output <- .fis$update_target_account_configuration_output()
  config <- get_config()
  svc <- .fis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$update_target_account_configuration <- fis_update_target_account_configuration
