# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codegurureviewer_service.R
NULL

#' Use to associate an Amazon Web Services CodeCommit repository or a
#' repository managed by Amazon Web Services CodeStar Connections with
#' Amazon CodeGuru Reviewer
#'
#' @description
#' Use to associate an Amazon Web Services CodeCommit repository or a repository managed by Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see [Recommendations in Amazon CodeGuru Reviewer](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html) in the *Amazon CodeGuru Reviewer User Guide.*
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_associate_repository/](https://www.paws-r-sdk.com/docs/codegurureviewer_associate_repository/) for full documentation.
#'
#' @param Repository &#91;required&#93; The repository to associate.
#' @param ClientRequestToken Amazon CodeGuru Reviewer uses this value to prevent the accidental
#' creation of duplicate repository associations if there are failures and
#' retries.
#' @param Tags An array of key-value pairs used to tag an associated repository. A tag
#' is a custom attribute label with two parts:
#' 
#' -   A *tag key* (for example, `CostCenter`, `Environment`, `Project`, or
#'     `Secret`). Tag keys are case sensitive.
#' 
#' -   An optional field known as a *tag value* (for example,
#'     `111122223333`, `Production`, or a team name). Omitting the tag
#'     value is the same as using an empty string. Like tag keys, tag
#'     values are case sensitive.
#' @param KMSKeyDetails A `KMSKeyDetails` object that contains:
#' 
#' -   The encryption option for this repository association. It is either
#'     owned by Amazon Web Services Key Management Service (KMS)
#'     (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
#' 
#' -   The ID of the Amazon Web Services KMS key that is associated with
#'     this repository association.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_associate_repository
codegurureviewer_associate_repository <- function(Repository, ClientRequestToken = NULL, Tags = NULL, KMSKeyDetails = NULL) {
  op <- new_operation(
    name = "AssociateRepository",
    http_method = "POST",
    http_path = "/associations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$associate_repository_input(Repository = Repository, ClientRequestToken = ClientRequestToken, Tags = Tags, KMSKeyDetails = KMSKeyDetails)
  output <- .codegurureviewer$associate_repository_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$associate_repository <- codegurureviewer_associate_repository

#' Use to create a code review with a CodeReviewType of RepositoryAnalysis
#'
#' @description
#' Use to create a code review with a [CodeReviewType](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html) of `RepositoryAnalysis`. This type of code review analyzes all code under a specified branch in an associated repository. `PullRequest` code reviews are automatically triggered by a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_create_code_review/](https://www.paws-r-sdk.com/docs/codegurureviewer_create_code_review/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the code review. The name of each code review in your Amazon
#' Web Services account must be unique.
#' @param RepositoryAssociationArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
#' object. You can retrieve this ARN by calling
#' [`list_repository_associations`][codegurureviewer_list_repository_associations].
#' 
#' A code review can only be created on an associated repository. This is
#' the ARN of the associated repository.
#' @param Type &#91;required&#93; The type of code review to create. This is specified using a
#' [CodeReviewType](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReviewType.html)
#' object. You can create a code review only of type `RepositoryAnalysis`.
#' @param ClientRequestToken Amazon CodeGuru Reviewer uses this value to prevent the accidental
#' creation of duplicate code reviews if there are failures and retries.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_create_code_review
codegurureviewer_create_code_review <- function(Name, RepositoryAssociationArn, Type, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateCodeReview",
    http_method = "POST",
    http_path = "/codereviews",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$create_code_review_input(Name = Name, RepositoryAssociationArn = RepositoryAssociationArn, Type = Type, ClientRequestToken = ClientRequestToken)
  output <- .codegurureviewer$create_code_review_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$create_code_review <- codegurureviewer_create_code_review

#' Returns the metadata associated with the code review along with its
#' status
#'
#' @description
#' Returns the metadata associated with the code review along with its status.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_describe_code_review/](https://www.paws-r-sdk.com/docs/codegurureviewer_describe_code_review/) for full documentation.
#'
#' @param CodeReviewArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
#' object.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_describe_code_review
codegurureviewer_describe_code_review <- function(CodeReviewArn) {
  op <- new_operation(
    name = "DescribeCodeReview",
    http_method = "GET",
    http_path = "/codereviews/{CodeReviewArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$describe_code_review_input(CodeReviewArn = CodeReviewArn)
  output <- .codegurureviewer$describe_code_review_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$describe_code_review <- codegurureviewer_describe_code_review

#' Describes the customer feedback for a CodeGuru Reviewer recommendation
#'
#' @description
#' Describes the customer feedback for a CodeGuru Reviewer recommendation.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_describe_recommendation_feedback/](https://www.paws-r-sdk.com/docs/codegurureviewer_describe_recommendation_feedback/) for full documentation.
#'
#' @param CodeReviewArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
#' object.
#' @param RecommendationId &#91;required&#93; The recommendation ID that can be used to track the provided
#' recommendations and then to collect the feedback.
#' @param UserId Optional parameter to describe the feedback for a given user. If this is
#' not supplied, it defaults to the user making the request.
#' 
#' The `UserId` is an IAM principal that can be specified as an Amazon Web
#' Services account ID or an Amazon Resource Name (ARN). For more
#' information, see [Specifying a
#' Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
#' in the *Amazon Web Services Identity and Access Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_describe_recommendation_feedback
codegurureviewer_describe_recommendation_feedback <- function(CodeReviewArn, RecommendationId, UserId = NULL) {
  op <- new_operation(
    name = "DescribeRecommendationFeedback",
    http_method = "GET",
    http_path = "/feedback/{CodeReviewArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$describe_recommendation_feedback_input(CodeReviewArn = CodeReviewArn, RecommendationId = RecommendationId, UserId = UserId)
  output <- .codegurureviewer$describe_recommendation_feedback_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$describe_recommendation_feedback <- codegurureviewer_describe_recommendation_feedback

#' Returns a RepositoryAssociation object that contains information about
#' the requested repository association
#'
#' @description
#' Returns a [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object that contains information about the requested repository association.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_describe_repository_association/](https://www.paws-r-sdk.com/docs/codegurureviewer_describe_repository_association/) for full documentation.
#'
#' @param AssociationArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
#' object. You can retrieve this ARN by calling
#' [`list_repository_associations`][codegurureviewer_list_repository_associations].
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_describe_repository_association
codegurureviewer_describe_repository_association <- function(AssociationArn) {
  op <- new_operation(
    name = "DescribeRepositoryAssociation",
    http_method = "GET",
    http_path = "/associations/{AssociationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$describe_repository_association_input(AssociationArn = AssociationArn)
  output <- .codegurureviewer$describe_repository_association_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$describe_repository_association <- codegurureviewer_describe_repository_association

#' Removes the association between Amazon CodeGuru Reviewer and a
#' repository
#'
#' @description
#' Removes the association between Amazon CodeGuru Reviewer and a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_disassociate_repository/](https://www.paws-r-sdk.com/docs/codegurureviewer_disassociate_repository/) for full documentation.
#'
#' @param AssociationArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
#' object. You can retrieve this ARN by calling
#' [`list_repository_associations`][codegurureviewer_list_repository_associations].
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_disassociate_repository
codegurureviewer_disassociate_repository <- function(AssociationArn) {
  op <- new_operation(
    name = "DisassociateRepository",
    http_method = "DELETE",
    http_path = "/associations/{AssociationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$disassociate_repository_input(AssociationArn = AssociationArn)
  output <- .codegurureviewer$disassociate_repository_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$disassociate_repository <- codegurureviewer_disassociate_repository

#' Lists all the code reviews that the customer has created in the past 90
#' days
#'
#' @description
#' Lists all the code reviews that the customer has created in the past 90 days.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_list_code_reviews/](https://www.paws-r-sdk.com/docs/codegurureviewer_list_code_reviews/) for full documentation.
#'
#' @param ProviderTypes List of provider types for filtering that needs to be applied before
#' displaying the result. For example, `providerTypes=[GitHub]` lists code
#' reviews from GitHub.
#' @param States List of states for filtering that needs to be applied before displaying
#' the result. For example, `states=[Pending]` lists code reviews in the
#' Pending state.
#' 
#' The valid code review states are:
#' 
#' -   `Completed`: The code review is complete.
#' 
#' -   `Pending`: The code review started and has not completed or failed.
#' 
#' -   `Failed`: The code review failed.
#' 
#' -   `Deleting`: The code review is being deleted.
#' @param RepositoryNames List of repository names for filtering that needs to be applied before
#' displaying the result.
#' @param Type &#91;required&#93; The type of code reviews to list in the response.
#' @param MaxResults The maximum number of results that are returned per call. The default is
#' 100.
#' @param NextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_list_code_reviews
codegurureviewer_list_code_reviews <- function(ProviderTypes = NULL, States = NULL, RepositoryNames = NULL, Type, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCodeReviews",
    http_method = "GET",
    http_path = "/codereviews",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .codegurureviewer$list_code_reviews_input(ProviderTypes = ProviderTypes, States = States, RepositoryNames = RepositoryNames, Type = Type, MaxResults = MaxResults, NextToken = NextToken)
  output <- .codegurureviewer$list_code_reviews_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$list_code_reviews <- codegurureviewer_list_code_reviews

#' Returns a list of RecommendationFeedbackSummary objects that contain
#' customer recommendation feedback for all CodeGuru Reviewer users
#'
#' @description
#' Returns a list of [RecommendationFeedbackSummary](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html) objects that contain customer recommendation feedback for all CodeGuru Reviewer users.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_list_recommendation_feedback/](https://www.paws-r-sdk.com/docs/codegurureviewer_list_recommendation_feedback/) for full documentation.
#'
#' @param NextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged.
#' @param MaxResults The maximum number of results that are returned per call. The default is
#' 100.
#' @param CodeReviewArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
#' object.
#' @param UserIds An Amazon Web Services user's account ID or Amazon Resource Name (ARN).
#' Use this ID to query the recommendation feedback for a code review from
#' that user.
#' 
#' The `UserId` is an IAM principal that can be specified as an Amazon Web
#' Services account ID or an Amazon Resource Name (ARN). For more
#' information, see [Specifying a
#' Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying)
#' in the *Amazon Web Services Identity and Access Management User Guide*.
#' @param RecommendationIds Used to query the recommendation feedback for a given recommendation.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_list_recommendation_feedback
codegurureviewer_list_recommendation_feedback <- function(NextToken = NULL, MaxResults = NULL, CodeReviewArn, UserIds = NULL, RecommendationIds = NULL) {
  op <- new_operation(
    name = "ListRecommendationFeedback",
    http_method = "GET",
    http_path = "/feedback/{CodeReviewArn}/RecommendationFeedback",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .codegurureviewer$list_recommendation_feedback_input(NextToken = NextToken, MaxResults = MaxResults, CodeReviewArn = CodeReviewArn, UserIds = UserIds, RecommendationIds = RecommendationIds)
  output <- .codegurureviewer$list_recommendation_feedback_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$list_recommendation_feedback <- codegurureviewer_list_recommendation_feedback

#' Returns the list of all recommendations for a completed code review
#'
#' @description
#' Returns the list of all recommendations for a completed code review.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_list_recommendations/](https://www.paws-r-sdk.com/docs/codegurureviewer_list_recommendations/) for full documentation.
#'
#' @param NextToken Pagination token.
#' @param MaxResults The maximum number of results that are returned per call. The default is
#' 100.
#' @param CodeReviewArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
#' object.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_list_recommendations
codegurureviewer_list_recommendations <- function(NextToken = NULL, MaxResults = NULL, CodeReviewArn) {
  op <- new_operation(
    name = "ListRecommendations",
    http_method = "GET",
    http_path = "/codereviews/{CodeReviewArn}/Recommendations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .codegurureviewer$list_recommendations_input(NextToken = NextToken, MaxResults = MaxResults, CodeReviewArn = CodeReviewArn)
  output <- .codegurureviewer$list_recommendations_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$list_recommendations <- codegurureviewer_list_recommendations

#' Returns a list of RepositoryAssociationSummary objects that contain
#' summary information about a repository association
#'
#' @description
#' Returns a list of [RepositoryAssociationSummary](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html) objects that contain summary information about a repository association. You can filter the returned list by [ProviderType](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType), [Name](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name), [State](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State), and [Owner](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner).
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_list_repository_associations/](https://www.paws-r-sdk.com/docs/codegurureviewer_list_repository_associations/) for full documentation.
#'
#' @param ProviderTypes List of provider types to use as a filter.
#' @param States List of repository association states to use as a filter.
#' 
#' The valid repository association states are:
#' 
#' -   **Associated**: The repository association is complete.
#' 
#' -   **Associating**: CodeGuru Reviewer is:
#' 
#'     -   Setting up pull request notifications. This is required for pull
#'         requests to trigger a CodeGuru Reviewer review.
#' 
#'         If your repository `ProviderType` is `GitHub`,
#'         `GitHub Enterprise Server`, or `Bitbucket`, CodeGuru Reviewer
#'         creates webhooks in your repository to trigger CodeGuru Reviewer
#'         reviews. If you delete these webhooks, reviews of code in your
#'         repository cannot be triggered.
#' 
#'     -   Setting up source code access. This is required for CodeGuru
#'         Reviewer to securely clone code in your repository.
#' 
#' -   **Failed**: The repository failed to associate or disassociate.
#' 
#' -   **Disassociating**: CodeGuru Reviewer is removing the repository's
#'     pull request notifications and source code access.
#' 
#' -   **Disassociated**: CodeGuru Reviewer successfully disassociated the
#'     repository. You can create a new association with this repository if
#'     you want to review source code in it later. You can control access
#'     to code reviews created in anassociated repository with tags after
#'     it has been disassociated. For more information, see [Using tags to
#'     control access to associated
#'     repositories](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html)
#'     in the *Amazon CodeGuru Reviewer User Guide*.
#' @param Names List of repository names to use as a filter.
#' @param Owners List of owners to use as a filter. For Amazon Web Services CodeCommit,
#' it is the name of the CodeCommit account that was used to associate the
#' repository. For other repository source providers, such as Bitbucket and
#' GitHub Enterprise Server, this is name of the account that was used to
#' associate the repository.
#' @param MaxResults The maximum number of repository association results returned by
#' [`list_repository_associations`][codegurureviewer_list_repository_associations]
#' in paginated output. When this parameter is used,
#' [`list_repository_associations`][codegurureviewer_list_repository_associations]
#' only returns `maxResults` results in a single page with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`list_repository_associations`][codegurureviewer_list_repository_associations]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If this parameter is not used,
#' [`list_repository_associations`][codegurureviewer_list_repository_associations]
#' returns up to 100 results and a `nextToken` value if applicable.
#' @param NextToken The `nextToken` value returned from a previous paginated
#' [`list_repository_associations`][codegurureviewer_list_repository_associations]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' 
#' Treat this token as an opaque identifier that is only used to retrieve
#' the next items in a list and not for other programmatic purposes.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_list_repository_associations
codegurureviewer_list_repository_associations <- function(ProviderTypes = NULL, States = NULL, Names = NULL, Owners = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRepositoryAssociations",
    http_method = "GET",
    http_path = "/associations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RepositoryAssociationSummaries"),
    stream_api = FALSE
  )
  input <- .codegurureviewer$list_repository_associations_input(ProviderTypes = ProviderTypes, States = States, Names = Names, Owners = Owners, MaxResults = MaxResults, NextToken = NextToken)
  output <- .codegurureviewer$list_repository_associations_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$list_repository_associations <- codegurureviewer_list_repository_associations

#' Returns the list of tags associated with an associated repository
#' resource
#'
#' @description
#' Returns the list of tags associated with an associated repository resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codegurureviewer_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
#' object. You can retrieve this ARN by calling
#' [`list_repository_associations`][codegurureviewer_list_repository_associations].
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_list_tags_for_resource
codegurureviewer_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .codegurureviewer$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$list_tags_for_resource <- codegurureviewer_list_tags_for_resource

#' Stores customer feedback for a CodeGuru Reviewer recommendation
#'
#' @description
#' Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_put_recommendation_feedback/](https://www.paws-r-sdk.com/docs/codegurureviewer_put_recommendation_feedback/) for full documentation.
#'
#' @param CodeReviewArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html)
#' object.
#' @param RecommendationId &#91;required&#93; The recommendation ID that can be used to track the provided
#' recommendations and then to collect the feedback.
#' @param Reactions &#91;required&#93; List for storing reactions. Reactions are utf-8 text code for emojis. If
#' you send an empty list it clears all your feedback.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_put_recommendation_feedback
codegurureviewer_put_recommendation_feedback <- function(CodeReviewArn, RecommendationId, Reactions) {
  op <- new_operation(
    name = "PutRecommendationFeedback",
    http_method = "PUT",
    http_path = "/feedback",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$put_recommendation_feedback_input(CodeReviewArn = CodeReviewArn, RecommendationId = RecommendationId, Reactions = Reactions)
  output <- .codegurureviewer$put_recommendation_feedback_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$put_recommendation_feedback <- codegurureviewer_put_recommendation_feedback

#' Adds one or more tags to an associated repository
#'
#' @description
#' Adds one or more tags to an associated repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_tag_resource/](https://www.paws-r-sdk.com/docs/codegurureviewer_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
#' object. You can retrieve this ARN by calling
#' [`list_repository_associations`][codegurureviewer_list_repository_associations].
#' @param Tags &#91;required&#93; An array of key-value pairs used to tag an associated repository. A tag
#' is a custom attribute label with two parts:
#' 
#' -   A *tag key* (for example, `CostCenter`, `Environment`, `Project`, or
#'     `Secret`). Tag keys are case sensitive.
#' 
#' -   An optional field known as a *tag value* (for example,
#'     `111122223333`, `Production`, or a team name). Omitting the tag
#'     value is the same as using an empty string. Like tag keys, tag
#'     values are case sensitive.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_tag_resource
codegurureviewer_tag_resource <- function(resourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$tag_resource_input(resourceArn = resourceArn, Tags = Tags)
  output <- .codegurureviewer$tag_resource_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$tag_resource <- codegurureviewer_tag_resource

#' Removes a tag from an associated repository
#'
#' @description
#' Removes a tag from an associated repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurureviewer_untag_resource/](https://www.paws-r-sdk.com/docs/codegurureviewer_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the
#' [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
#' object. You can retrieve this ARN by calling
#' [`list_repository_associations`][codegurureviewer_list_repository_associations].
#' @param TagKeys &#91;required&#93; A list of the keys for each tag you want to remove from an associated
#' repository.
#'
#' @keywords internal
#'
#' @rdname codegurureviewer_untag_resource
codegurureviewer_untag_resource <- function(resourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .codegurureviewer$untag_resource_input(resourceArn = resourceArn, TagKeys = TagKeys)
  output <- .codegurureviewer$untag_resource_output()
  config <- get_config()
  svc <- .codegurureviewer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurureviewer$operations$untag_resource <- codegurureviewer_untag_resource
