% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_traffic_mirror_filter_rules}
\alias{ec2_describe_traffic_mirror_filter_rules}
\title{Describe traffic mirror filters that determine the traffic that is
mirrored}
\usage{
ec2_describe_traffic_mirror_filter_rules(
  TrafficMirrorFilterRuleIds = NULL,
  TrafficMirrorFilterId = NULL,
  DryRun = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{TrafficMirrorFilterRuleIds}{Traffic filter rule IDs.}

\item{TrafficMirrorFilterId}{Traffic filter ID.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{Traffic mirror filters.
\itemize{
\item \code{traffic-mirror-filter-rule-id}: The ID of the Traffic Mirror rule.
\item \code{traffic-mirror-filter-id}: The ID of the filter that this rule is
associated with.
\item \code{rule-number}: The number of the Traffic Mirror rule.
\item \code{rule-action}: The action taken on the filtered traffic. Possible
actions are \code{accept} and \code{reject}.
\item \code{traffic-direction}: The traffic direction. Possible directions are
\code{ingress} and \code{egress}.
\item \code{protocol}: The protocol, for example UDP, assigned to the Traffic
Mirror rule.
\item \code{source-cidr-block}: The source CIDR block assigned to the Traffic
Mirror rule.
\item \code{destination-cidr-block}: The destination CIDR block assigned to the
Traffic Mirror rule.
\item \code{description}: The description of the Traffic Mirror rule.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describe traffic mirror filters that determine the traffic that is mirrored.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_filter_rules/} for full documentation.
}
\keyword{internal}
