% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_poll_for_decision_task}
\alias{swf_poll_for_decision_task}
\title{Used by deciders to get a DecisionTask from the specified decision
taskList}
\usage{
swf_poll_for_decision_task(
  domain,
  taskList,
  identity = NULL,
  nextPageToken = NULL,
  maximumPageSize = NULL,
  reverseOrder = NULL,
  startAtPreviousStartedEvent = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain containing the task lists to poll.}

\item{taskList}{[required] Specifies the task list to poll for decision tasks.

The specified string must not contain a \code{:} (colon), \code{/} (slash), \code{|}
(vertical bar), or any control characters (\verb{U+0000`-`U+001f} |
\verb{U+007f`-`U+009f}). Also, it must \emph{not} be the literal string \code{arn}.}

\item{identity}{Identity of the decider making the request, which is recorded in the
DecisionTaskStarted event in the workflow history. This enables
diagnostic tracing when problems arise. The form of this identity is
user defined.}

\item{nextPageToken}{If \code{NextPageToken} is returned there are more results available. The
value of \code{NextPageToken} is a unique pagination token for each page.
Make the call again using the returned token to retrieve the next page.
Keep all other arguments unchanged. Each pagination token expires after
24 hours. Using an expired pagination token will return a \code{400} error:
"\verb{Specified token has exceeded its maximum lifetime}".

The configured \code{maximumPageSize} determines how many results can be
returned in a single call.

The \code{nextPageToken} returned by this action cannot be used with
\code{\link[=swf_get_workflow_execution_history]{get_workflow_execution_history}}
to get the next page. You must call
\code{\link[=swf_poll_for_decision_task]{poll_for_decision_task}} again (with the
\code{nextPageToken}) to retrieve the next page of history records. Calling
\code{\link[=swf_poll_for_decision_task]{poll_for_decision_task}} with a
\code{nextPageToken} doesn't return a new decision task.}

\item{maximumPageSize}{The maximum number of results that are returned per call. Use
\code{nextPageToken} to obtain further pages of results.

This is an upper limit only; the actual number of results returned per
call may be fewer than the specified maximum.}

\item{reverseOrder}{When set to \code{true}, returns the events in reverse order. By default the
results are returned in ascending order of the \code{eventTimestamp} of the
events.}

\item{startAtPreviousStartedEvent}{When set to \code{true}, returns the events with \code{eventTimestamp} greater
than or equal to \code{eventTimestamp} of the most recent
\code{DecisionTaskStarted} event. By default, this parameter is set to
\code{false}.}
}
\description{
Used by deciders to get a DecisionTask from the specified decision \code{taskList}. A decision task may be returned for any open workflow execution that is using the specified task list. The task includes a paginated view of the history of the workflow execution. The decider should use the workflow type and the history to determine how to properly handle the task.

See \url{https://www.paws-r-sdk.com/docs/swf_poll_for_decision_task/} for full documentation.
}
\keyword{internal}
