% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_publish_state_machine_version}
\alias{sfn_publish_state_machine_version}
\title{Creates a version from the current revision of a state machine}
\usage{
sfn_publish_state_machine_version(
  stateMachineArn,
  revisionId = NULL,
  description = NULL
)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine.}

\item{revisionId}{Only publish the state machine version if the current state machine's
revision ID matches the specified ID.

Use this option to avoid publishing a version if the state machine
changed since you last updated it. If the specified revision ID doesn't
match the state machine's current revision ID, the API returns
\code{ConflictException}.

To specify an initial revision ID for a state machine with no revision
ID assigned, specify the string \code{INITIAL} for the \code{revisionId}
parameter. For example, you can specify a \code{revisionID} of \code{INITIAL} when
you create a state machine using the
\code{\link[=sfn_create_state_machine]{create_state_machine}} API action.}

\item{description}{An optional description of the state machine version.}
}
\description{
Creates a \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html}{version} from the current revision of a state machine. Use versions to create immutable snapshots of your state machine. You can start executions from versions either directly or with an alias. To create an alias, use \code{\link[=sfn_create_state_machine_alias]{create_state_machine_alias}}.

See \url{https://www.paws-r-sdk.com/docs/sfn_publish_state_machine_version/} for full documentation.
}
\keyword{internal}
